import sys
import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")


def brush_stroke(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        stroke: typing.Optional[bpy.types.bpy_prop_collection[
            'bpy.types.OperatorStrokeElement']] = None,
        mode: typing.Optional[typing.Any] = 'NORMAL',
        ignore_background_click: typing.Union[bool, typing.Any] = False):
    ''' Sculpt a stroke into the geometry

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param stroke: Stroke
    :type stroke: typing.Optional[bpy.types.bpy_prop_collection['bpy.types.OperatorStrokeElement']]
    :param mode: Stroke Mode, Action taken when a paint stroke is made * ``NORMAL`` Regular, Apply brush normally. * ``INVERT`` Invert, Invert action of brush for duration of stroke. * ``SMOOTH`` Smooth, Switch brush to smooth mode for duration of stroke.
    :type mode: typing.Optional[typing.Any]
    :param ignore_background_click: Ignore Background Click, Clicks on the background do not start the stroke
    :type ignore_background_click: typing.Union[bool, typing.Any]
    '''

    pass


def cloth_filter(override_context: typing.
                 Union[typing.Dict, 'bpy.types.Context'] = None,
                 execution_context: typing.Union[str, int] = None,
                 undo: typing.Optional[bool] = None,
                 *,
                 type: typing.Optional[typing.Any] = 'GRAVITY',
                 strength: typing.Optional[typing.Any] = 1.0,
                 cloth_mass: typing.Optional[typing.Any] = 1.0,
                 cloth_damping: typing.Optional[typing.Any] = 0.0,
                 use_face_sets: typing.Union[bool, typing.Any] = False):
    ''' Applies a cloth simulation deformation to the entire mesh

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: Filter type, Operation that is going to be applied to the mesh * ``GRAVITY`` Gravity, Applies gravity to the simulation. * ``INFLATE`` Inflate, Inflates the cloth. * ``EXPAND`` Expand, Expands the cloth's dimensions. * ``PINCH`` Pinch, Pinches the cloth to the point where the cursor was when the filter started.
    :type type: typing.Optional[typing.Any]
    :param strength: Strength, Filter Strength
    :type strength: typing.Optional[typing.Any]
    :param cloth_mass: Cloth Mass, Mass of each simulation particle
    :type cloth_mass: typing.Optional[typing.Any]
    :param cloth_damping: Cloth Damping, How much the applied forces are propagated through the cloth
    :type cloth_damping: typing.Optional[typing.Any]
    :param use_face_sets: Use Face Sets, Apply the filter only to the Face Set under the cursor
    :type use_face_sets: typing.Union[bool, typing.Any]
    '''

    pass


def color_filter(override_context: typing.
                 Union[typing.Dict, 'bpy.types.Context'] = None,
                 execution_context: typing.Union[str, int] = None,
                 undo: typing.Optional[bool] = None,
                 *,
                 type: typing.Optional[typing.Any] = 'HUE',
                 strength: typing.Optional[typing.Any] = 1.0,
                 fill_color: typing.Optional[typing.Any] = (0.0, 0.0, 0.0)):
    ''' Applies a filter to modify the current sculpt vertex colors

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: Filter type * ``FILL`` Fill, Fill with a specific color. * ``HUE`` Hue, Change hue. * ``SATURATION`` Saturation, Change saturation. * ``VALUE`` Value, Change value. * ``BRIGTHNESS`` Brightness, Change brightness. * ``CONTRAST`` Contrast, Change contrast. * ``SMOOTH`` Smooth, Smooth colors. * ``RED`` Red, Change red channel. * ``GREEN`` Green, Change green channel. * ``BLUE`` Blue, Change blue channel.
    :type type: typing.Optional[typing.Any]
    :param strength: Strength, Filter Strength
    :type strength: typing.Optional[typing.Any]
    :param fill_color: Fill Color
    :type fill_color: typing.Optional[typing.Any]
    '''

    pass


def detail_flood_fill(override_context: typing.
                      Union[typing.Dict, 'bpy.types.Context'] = None,
                      execution_context: typing.Union[str, int] = None,
                      undo: typing.Optional[bool] = None):
    ''' Flood fill the mesh with the selected detail setting

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def dirty_mask(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None,
               *,
               dirty_only: typing.Union[bool, typing.Any] = False):
    ''' Generates a mask based on the geometry cavity and pointiness

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param dirty_only: Dirty Only, Don't calculate cleans for convex areas
    :type dirty_only: typing.Union[bool, typing.Any]
    '''

    pass


def dynamic_topology_toggle(override_context: typing.
                            Union[typing.Dict, 'bpy.types.Context'] = None,
                            execution_context: typing.Union[str, int] = None,
                            undo: typing.Optional[bool] = None):
    ''' Dynamic topology alters the mesh topology while sculpting

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def face_set_change_visibility(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        mode: typing.Optional[typing.Any] = 'TOGGLE'):
    ''' Change the visibility of the Face Sets of the sculpt

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode * ``TOGGLE`` Toggle Visibility, Hide all Face Sets except for the active one. * ``SHOW_ACTIVE`` Show Active Face Set, Show Active Face Set. * ``HIDE_ACTIVE`` Hide Active Face Sets, Hide Active Face Sets. * ``INVERT`` Invert Face Set Visibility, Invert Face Set Visibility. * ``SHOW_ALL`` Show All Face Sets, Show All Face Sets.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def face_set_edit(override_context: typing.
                  Union[typing.Dict, 'bpy.types.Context'] = None,
                  execution_context: typing.Union[str, int] = None,
                  undo: typing.Optional[bool] = None,
                  *,
                  mode: typing.Optional[typing.Any] = 'GROW'):
    ''' Edits the current active Face Set

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode * ``GROW`` Grow Face Set, Grows the Face Sets boundary by one face based on mesh topology. * ``SHRINK`` Shrink Face Set, Shrinks the Face Sets boundary by one face based on mesh topology.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def face_sets_create(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None,
                     *,
                     mode: typing.Optional[typing.Any] = 'MASKED'):
    ''' Create a new Face Set

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode * ``MASKED`` Face Set From Masked, Create a new Face Set from the masked faces. * ``VISIBLE`` Face Set From Visible, Create a new Face Set from the visible vertices. * ``ALL`` Face Set Full Mesh, Create an unique Face Set with all faces in the sculpt. * ``SELECTION`` Face Set From Edit Mode Selection, Create an Face Set corresponding to the Edit Mode face selection.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def face_sets_init(override_context: typing.
                   Union[typing.Dict, 'bpy.types.Context'] = None,
                   execution_context: typing.Union[str, int] = None,
                   undo: typing.Optional[bool] = None,
                   *,
                   mode: typing.Optional[typing.Any] = 'LOOSE_PARTS',
                   threshold: typing.Optional[typing.Any] = 0.5):
    ''' Initializes all Face Sets in the mesh

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode * ``LOOSE_PARTS`` Face Sets From Loose Parts, Create a Face Set per loose part in the mesh. * ``MATERIALS`` Face Sets From Material Slots, Create a Face Set per Material Slot. * ``NORMALS`` Face Sets From Mesh Normals, Create Face Sets for Faces that have similar normal. * ``UV_SEAMS`` Face Sets From UV Seams, Create Face Sets using UV Seams as boundaries. * ``CREASES`` Face Sets From Edge Creases, Create Face Sets using Edge Creases as boundaries. * ``BEVEL_WEIGHT`` Face Sets From Bevel Weight, Create Face Sets using Bevel Weights as boundaries. * ``SHARP_EDGES`` Face Sets From Sharp Edges, Create Face Sets using Sharp Edges as boundaries. * ``FACE_MAPS`` Face Sets From Face Maps, Create a Face Set per Face Map.
    :type mode: typing.Optional[typing.Any]
    :param threshold: Threshold, Minimum value to consider a certain attribute a boundary when creating the Face Sets
    :type threshold: typing.Optional[typing.Any]
    '''

    pass


def face_sets_randomize_colors(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None):
    ''' Generates a new set of random colors to render the Face Sets in the viewport

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def loop_to_vertex_colors(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Copy the active loop color layer to the vertex color

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def mask_by_color(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        contiguous: typing.Union[bool, typing.Any] = False,
        invert: typing.Union[bool, typing.Any] = False,
        preserve_previous_mask: typing.Union[bool, typing.Any] = False,
        threshold: typing.Optional[typing.Any] = 0.35):
    ''' Creates a mask based on the sculpt vertex colors

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param contiguous: Contiguous, Mask only contiguous color areas
    :type contiguous: typing.Union[bool, typing.Any]
    :param invert: Invert, Invert the generated mask
    :type invert: typing.Union[bool, typing.Any]
    :param preserve_previous_mask: Preserve Previous Mask, Preserve the previous mask and add or subtract the new one generated by the colors
    :type preserve_previous_mask: typing.Union[bool, typing.Any]
    :param threshold: Threshold, How much changes in color affect the mask generation
    :type threshold: typing.Optional[typing.Any]
    '''

    pass


def mask_expand(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                invert: typing.Union[bool, typing.Any] = True,
                use_cursor: typing.Union[bool, typing.Any] = True,
                update_pivot: typing.Union[bool, typing.Any] = True,
                smooth_iterations: typing.Optional[typing.Any] = 2,
                mask_speed: typing.Optional[typing.Any] = 5,
                use_normals: typing.Union[bool, typing.Any] = True,
                keep_previous_mask: typing.Union[bool, typing.Any] = False,
                edge_sensitivity: typing.Optional[typing.Any] = 300,
                create_face_set: typing.Union[bool, typing.Any] = False):
    ''' Expands a mask from the initial active vertex under the cursor

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param invert: Invert, Invert the new mask
    :type invert: typing.Union[bool, typing.Any]
    :param use_cursor: Use Cursor, Expand the mask to the cursor position
    :type use_cursor: typing.Union[bool, typing.Any]
    :param update_pivot: Update Pivot Position, Set the pivot position to the mask border after creating the mask
    :type update_pivot: typing.Union[bool, typing.Any]
    :param smooth_iterations: Smooth iterations
    :type smooth_iterations: typing.Optional[typing.Any]
    :param mask_speed: Mask speed
    :type mask_speed: typing.Optional[typing.Any]
    :param use_normals: Use Normals, Generate the mask using the normals and curvature of the model
    :type use_normals: typing.Union[bool, typing.Any]
    :param keep_previous_mask: Keep Previous Mask, Generate the new mask on top of the current one
    :type keep_previous_mask: typing.Union[bool, typing.Any]
    :param edge_sensitivity: Edge Detection Sensitivity, Sensitivity for expanding the mask across sculpted sharp edges when using normals to generate the mask
    :type edge_sensitivity: typing.Optional[typing.Any]
    :param create_face_set: Expand Face Mask, Expand a new Face Mask instead of the sculpt mask
    :type create_face_set: typing.Union[bool, typing.Any]
    '''

    pass


def mask_filter(override_context: typing.
                Union[typing.Dict, 'bpy.types.Context'] = None,
                execution_context: typing.Union[str, int] = None,
                undo: typing.Optional[bool] = None,
                *,
                filter_type: typing.Optional[typing.Any] = 'SMOOTH',
                iterations: typing.Optional[typing.Any] = 1,
                auto_iteration_count: typing.Union[bool, typing.Any] = False):
    ''' Applies a filter to modify the current mask

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param filter_type: Type, Filter that is going to be applied to the mask * ``SMOOTH`` Smooth Mask, Smooth mask. * ``SHARPEN`` Sharpen Mask, Sharpen mask. * ``GROW`` Grow Mask, Grow mask. * ``SHRINK`` Shrink Mask, Shrink mask. * ``CONTRAST_INCREASE`` Increase contrast, Increase the contrast of the paint mask. * ``CONTRAST_DECREASE`` Decrease contrast, Decrease the contrast of the paint mask.
    :type filter_type: typing.Optional[typing.Any]
    :param iterations: Iterations, Number of times that the filter is going to be applied
    :type iterations: typing.Optional[typing.Any]
    :param auto_iteration_count: Auto Iteration Count, Use a automatic number of iterations based on the number of vertices of the sculpt
    :type auto_iteration_count: typing.Union[bool, typing.Any]
    '''

    pass


def mesh_filter(
        override_context: typing.Union[typing.
                                       Dict, 'bpy.types.Context'] = None,
        execution_context: typing.Union[str, int] = None,
        undo: typing.Optional[bool] = None,
        *,
        type: typing.Optional[typing.Any] = 'INFLATE',
        strength: typing.Optional[typing.Any] = 1.0,
        deform_axis: typing.Optional[typing.Any] = {'X', 'Y', 'Z'},
        use_face_sets: typing.Union[bool, typing.Any] = False,
        surface_smooth_shape_preservation: typing.Optional[typing.Any] = 0.5,
        surface_smooth_current_vertex: typing.Optional[typing.Any] = 0.5,
        sharpen_smooth_ratio: typing.Optional[typing.Any] = 0.35):
    ''' Applies a filter to modify the current mesh

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param type: Filter type, Operation that is going to be applied to the mesh * ``SMOOTH`` Smooth, Smooth mesh. * ``SCALE`` Scale, Scale mesh. * ``INFLATE`` Inflate, Inflate mesh. * ``SPHERE`` Sphere, Morph into sphere. * ``RANDOM`` Random, Randomize vertex positions. * ``RELAX`` Relax, Relax mesh. * ``RELAX_FACE_SETS`` Relax Face Sets, Smooth the edges of all the Face Sets. * ``SURFACE_SMOOTH`` Surface Smooth, Smooth the surface of the mesh, preserving the volume. * ``SHARPEN`` Sharpen, Sharpen the cavities of the mesh.
    :type type: typing.Optional[typing.Any]
    :param strength: Strength, Filter Strength
    :type strength: typing.Optional[typing.Any]
    :param deform_axis: Deform axis, Apply the deformation in the selected axis * ``X`` X, Deform in the X axis. * ``Y`` Y, Deform in the Y axis. * ``Z`` Z, Deform in the Z axis.
    :type deform_axis: typing.Optional[typing.Any]
    :param use_face_sets: Use Face Sets, Apply the filter only to the Face Mask under the cursor
    :type use_face_sets: typing.Union[bool, typing.Any]
    :param surface_smooth_shape_preservation: Shape Preservation, How much of the original shape is preserved when smoothing
    :type surface_smooth_shape_preservation: typing.Optional[typing.Any]
    :param surface_smooth_current_vertex: Per Vertex Displacement, How much the position of each individual vertex influences the final result
    :type surface_smooth_current_vertex: typing.Optional[typing.Any]
    :param sharpen_smooth_ratio: Smooth Ratio, How much smoothing is applied to polished surfaces
    :type sharpen_smooth_ratio: typing.Optional[typing.Any]
    '''

    pass


def optimize(override_context: typing.Union[typing.
                                            Dict, 'bpy.types.Context'] = None,
             execution_context: typing.Union[str, int] = None,
             undo: typing.Optional[bool] = None):
    ''' Recalculate the sculpt BVH to improve performance

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def sample_color(override_context: typing.
                 Union[typing.Dict, 'bpy.types.Context'] = None,
                 execution_context: typing.Union[str, int] = None,
                 undo: typing.Optional[bool] = None):
    ''' Sample the vertex color of the active vertex

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def sample_detail_size(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None,
                       *,
                       location: typing.Optional[typing.Any] = (0, 0),
                       mode: typing.Optional[typing.Any] = 'DYNTOPO'):
    ''' Sample the mesh detail on clicked point

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param location: Location, Screen Coordinates of sampling
    :type location: typing.Optional[typing.Any]
    :param mode: Detail Mode, Target sculpting workflow that is going to use the sampled size * ``DYNTOPO`` Dyntopo, Sample dyntopo detail. * ``VOXEL`` Voxel, Sample mesh voxel size.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def sculptmode_toggle(override_context: typing.
                      Union[typing.Dict, 'bpy.types.Context'] = None,
                      execution_context: typing.Union[str, int] = None,
                      undo: typing.Optional[bool] = None):
    ''' Toggle sculpt mode in 3D view

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def set_detail_size(override_context: typing.
                    Union[typing.Dict, 'bpy.types.Context'] = None,
                    execution_context: typing.Union[str, int] = None,
                    undo: typing.Optional[bool] = None):
    ''' Set the mesh detail (either relative or constant one, depending on current dyntopo mode)

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def set_persistent_base(override_context: typing.
                        Union[typing.Dict, 'bpy.types.Context'] = None,
                        execution_context: typing.Union[str, int] = None,
                        undo: typing.Optional[bool] = None):
    ''' Reset the copy of the mesh that is being sculpted on

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass


def set_pivot_position(override_context: typing.
                       Union[typing.Dict, 'bpy.types.Context'] = None,
                       execution_context: typing.Union[str, int] = None,
                       undo: typing.Optional[bool] = None,
                       *,
                       mode: typing.Optional[typing.Any] = 'UNMASKED',
                       mouse_x: typing.Optional[typing.Any] = 0.0,
                       mouse_y: typing.Optional[typing.Any] = 0.0):
    ''' Sets the sculpt transform pivot position

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode * ``ORIGIN`` Origin, Sets the pivot to the origin of the sculpt. * ``UNMASKED`` Unmasked, Sets the pivot position to the average position of the unmasked vertices. * ``BORDER`` Mask border, Sets the pivot position to the center of the border of the mask. * ``ACTIVE`` Active vertex, Sets the pivot position to the active vertex position. * ``SURFACE`` Surface, Sets the pivot position to the surface under the cursor.
    :type mode: typing.Optional[typing.Any]
    :param mouse_x: Mouse Position X, Position of the mouse used for "Surface" mode
    :type mouse_x: typing.Optional[typing.Any]
    :param mouse_y: Mouse Position Y, Position of the mouse used for "Surface" mode
    :type mouse_y: typing.Optional[typing.Any]
    '''

    pass


def symmetrize(override_context: typing.
               Union[typing.Dict, 'bpy.types.Context'] = None,
               execution_context: typing.Union[str, int] = None,
               undo: typing.Optional[bool] = None,
               *,
               merge_tolerance: typing.Optional[typing.Any] = 0.001):
    ''' Symmetrize the topology modifications

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param merge_tolerance: Merge Distance, Distance within which symmetrical vertices are merged
    :type merge_tolerance: typing.Optional[typing.Any]
    '''

    pass


def uv_sculpt_stroke(override_context: typing.
                     Union[typing.Dict, 'bpy.types.Context'] = None,
                     execution_context: typing.Union[str, int] = None,
                     undo: typing.Optional[bool] = None,
                     *,
                     mode: typing.Optional[typing.Any] = 'NORMAL'):
    ''' Sculpt UVs using a brush

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    :param mode: Mode, Stroke Mode * ``NORMAL`` Regular, Apply brush normally. * ``INVERT`` Invert, Invert action of brush for duration of stroke. * ``RELAX`` Relax, Switch brush to relax mode for duration of stroke.
    :type mode: typing.Optional[typing.Any]
    '''

    pass


def vertex_to_loop_colors(override_context: typing.
                          Union[typing.Dict, 'bpy.types.Context'] = None,
                          execution_context: typing.Union[str, int] = None,
                          undo: typing.Optional[bool] = None):
    ''' Copy the Sculpt Vertex Color to a regular color layer

    :type override_context: typing.Union[typing.Dict, 'bpy.types.Context']
    :type execution_context: typing.Union[str, int]
    :type undo: typing.Optional[bool]
    '''

    pass
