"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_private_bucket_1 = require("@pepperize/cdk-private-bucket");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 */
class Cache extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`
            .slice(-63)
            .toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = props.expiration ?? aws_cdk_lib_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new cdk_private_bucket_1.PrivateBucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.2.169" };
//# sourceMappingURL=data:application/json;base64,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