# Generated by ariadne-codegen
# Source: queries.async.graphql

from typing import Any, List, Literal, Optional, Union

from pydantic import Field

from .base_model import BaseModel
from .enums import CmeSecurityType, MinOrderQuantityUnit, OrderSource, OrderStateFlags


class ProductFields(BaseModel):
    typename__: str = Field(alias="__typename")
    id: Any
    name: str
    kind: str
    mark_usd: Optional[Any] = Field(alias="markUsd")


class MarketFields(BaseModel):
    typename__: str = Field(alias="__typename")
    venue: "MarketFieldsVenue"
    exchange_symbol: str = Field(alias="exchangeSymbol")
    id: Any
    cme_product_group_info: Optional["MarketFieldsCmeProductGroupInfo"] = Field(
        alias="cmeProductGroupInfo"
    )
    kind: Union[
        "MarketFieldsKindExchangeMarketKind",
        "MarketFieldsKindPoolMarketKind",
        "MarketFieldsKindUnknownMarketKind",
    ] = Field(discriminator="typename__")
    name: str
    tick_size: Any = Field(alias="tickSize")
    step_size: Any = Field(alias="stepSize")
    min_order_quantity: Any = Field(alias="minOrderQuantity")
    min_order_quantity_unit: MinOrderQuantityUnit = Field(alias="minOrderQuantityUnit")
    route: "MarketFieldsRoute"
    is_favorite: bool = Field(alias="isFavorite")


class MarketFieldsVenue(BaseModel):
    id: Any
    name: Any


class MarketFieldsCmeProductGroupInfo(BaseModel):
    product_name: Optional[str] = Field(alias="productName")
    security_type: CmeSecurityType = Field(alias="securityType")
    category: Optional[str]
    sub_category: Optional[str] = Field(alias="subCategory")
    main_fraction: Optional[int] = Field(alias="mainFraction")


class MarketFieldsKindExchangeMarketKind(BaseModel):
    typename__: Literal["ExchangeMarketKind"] = Field(alias="__typename")
    base: "MarketFieldsKindExchangeMarketKindBase"
    quote: "MarketFieldsKindExchangeMarketKindQuote"


class MarketFieldsKindExchangeMarketKindBase(ProductFields):
    pass


class MarketFieldsKindExchangeMarketKindQuote(ProductFields):
    pass


class MarketFieldsKindPoolMarketKind(BaseModel):
    typename__: Literal["PoolMarketKind"] = Field(alias="__typename")
    products: List["MarketFieldsKindPoolMarketKindProducts"]


class MarketFieldsKindPoolMarketKindProducts(ProductFields):
    pass


class MarketFieldsKindUnknownMarketKind(BaseModel):
    typename__: Literal["UnknownMarketKind"] = Field(alias="__typename")


class MarketFieldsRoute(BaseModel):
    id: Any
    name: Any


class AccountSummariesFields(BaseModel):
    snapshot_ts: Any = Field(alias="snapshotTs")
    by_account: List["AccountSummariesFieldsByAccount"] = Field(alias="byAccount")


class AccountSummariesFieldsByAccount(BaseModel):
    account: Optional["AccountSummariesFieldsByAccountAccount"]
    balances: List["AccountSummariesFieldsByAccountBalances"]
    positions: List["AccountSummariesFieldsByAccountPositions"]


class AccountSummariesFieldsByAccountAccount(BaseModel):
    id: Any
    name: str


class AccountSummariesFieldsByAccountBalances(BaseModel):
    product: Optional["AccountSummariesFieldsByAccountBalancesProduct"]
    account: Optional["AccountSummariesFieldsByAccountBalancesAccount"]
    venue: Optional["AccountSummariesFieldsByAccountBalancesVenue"]
    amount: Optional[Any]
    total_margin: Optional[Any] = Field(alias="totalMargin")
    position_margin: Optional[Any] = Field(alias="positionMargin")
    purchasing_power: Optional[Any] = Field(alias="purchasingPower")
    cash_excess: Optional[Any] = Field(alias="cashExcess")
    yesterday_balance: Optional[Any] = Field(alias="yesterdayBalance")


class AccountSummariesFieldsByAccountBalancesProduct(ProductFields):
    pass


class AccountSummariesFieldsByAccountBalancesAccount(BaseModel):
    id: Any
    name: str


class AccountSummariesFieldsByAccountBalancesVenue(BaseModel):
    id: Any
    name: Any


class AccountSummariesFieldsByAccountPositions(BaseModel):
    account: Optional["AccountSummariesFieldsByAccountPositionsAccount"]
    venue: Optional["AccountSummariesFieldsByAccountPositionsVenue"]
    market: Optional["AccountSummariesFieldsByAccountPositionsMarket"]
    dir: Any
    quantity: Optional[Any]
    average_price: Optional[Any] = Field(alias="averagePrice")
    trade_date: Optional[Any] = Field(alias="tradeDate")
    trade_time: Optional[Any] = Field(alias="tradeTime")


class AccountSummariesFieldsByAccountPositionsAccount(BaseModel):
    id: Any
    name: str


class AccountSummariesFieldsByAccountPositionsVenue(BaseModel):
    id: Any
    name: Any


class AccountSummariesFieldsByAccountPositionsMarket(MarketFields):
    pass


class CandleFields(BaseModel):
    time: Any
    open: Any
    high: Any
    low: Any
    close: Any
    volume: Any


class MarketSnapshotFields(BaseModel):
    typename__: str = Field(alias="__typename")
    market_id: Any = Field(alias="marketId")
    market: Optional["MarketSnapshotFieldsMarket"]
    high_24_h: Optional[Any] = Field(alias="high24h")
    last_price: Optional[Any] = Field(alias="lastPrice")
    low_24_h: Optional[Any] = Field(alias="low24h")
    volume_24_h: Optional[Any] = Field(alias="volume24h")
    open_24_h: Optional[Any] = Field(alias="open24h")
    bid_price: Optional[Any] = Field(alias="bidPrice")
    ask_price: Optional[Any] = Field(alias="askPrice")


class MarketSnapshotFieldsMarket(BaseModel):
    name: str


class OrderFields(BaseModel):
    id: Any
    market_id: Any = Field(alias="marketId")
    market: "OrderFieldsMarket"
    dir: Any
    quantity: Any
    account_id: Optional[Any] = Field(alias="accountId")
    order_type: Union[
        "OrderFieldsOrderTypeLimitOrderType",
        "OrderFieldsOrderTypeStopLossLimitOrderType",
        "OrderFieldsOrderTypeTakeProfitLimitOrderType",
    ] = Field(alias="orderType", discriminator="typename__")
    time_in_force: "OrderFieldsTimeInForce" = Field(alias="timeInForce")
    quote_id: Optional[Any] = Field(alias="quoteId")
    source: OrderSource


class OrderFieldsMarket(MarketFields):
    pass


class OrderFieldsOrderTypeLimitOrderType(BaseModel):
    typename__: Literal["LimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")
    post_only: bool = Field(alias="postOnly")


class OrderFieldsOrderTypeStopLossLimitOrderType(BaseModel):
    typename__: Literal["StopLossLimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")
    trigger_price: Any = Field(alias="triggerPrice")


class OrderFieldsOrderTypeTakeProfitLimitOrderType(BaseModel):
    typename__: Literal["TakeProfitLimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")
    trigger_price: Any = Field(alias="triggerPrice")


class OrderFieldsTimeInForce(BaseModel):
    instruction: str
    good_til_date: Optional[Any] = Field(alias="goodTilDate")


class OrderLogFields(BaseModel):
    typename__: str = Field(alias="__typename")
    timestamp: Any
    order: "OrderLogFieldsOrder"
    order_state: List[OrderStateFlags] = Field(alias="orderState")
    filled_qty: Any = Field(alias="filledQty")
    avg_fill_price: Optional[Any] = Field(alias="avgFillPrice")
    reject_reason: Optional[str] = Field(alias="rejectReason")


class OrderLogFieldsOrder(BaseModel):
    id: Any
    market: "OrderLogFieldsOrderMarket"
    dir: Any
    quantity: Any
    order_type: Union[
        "OrderLogFieldsOrderOrderTypeLimitOrderType",
        "OrderLogFieldsOrderOrderTypeStopLossLimitOrderType",
        "OrderLogFieldsOrderOrderTypeTakeProfitLimitOrderType",
    ] = Field(alias="orderType", discriminator="typename__")


class OrderLogFieldsOrderMarket(MarketFields):
    pass


class OrderLogFieldsOrderOrderTypeLimitOrderType(BaseModel):
    typename__: Literal["LimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")


class OrderLogFieldsOrderOrderTypeStopLossLimitOrderType(BaseModel):
    typename__: Literal["StopLossLimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")
    trigger_price: Any = Field(alias="triggerPrice")


class OrderLogFieldsOrderOrderTypeTakeProfitLimitOrderType(BaseModel):
    typename__: Literal["TakeProfitLimitOrderType"] = Field(alias="__typename")
    limit_price: Any = Field(alias="limitPrice")
    trigger_price: Any = Field(alias="triggerPrice")


ProductFields.model_rebuild()
MarketFields.model_rebuild()
AccountSummariesFields.model_rebuild()
CandleFields.model_rebuild()
MarketSnapshotFields.model_rebuild()
OrderFields.model_rebuild()
OrderLogFields.model_rebuild()
