# Generated by ariadne-codegen
# Source: queries.async.graphql

from typing import Any, AsyncIterator, Dict, List, Optional, Union

from .base_model import UNSET, UnsetType
from .cancel_all_orders import CancelAllOrders
from .cancel_order import CancelOrder
from .cancel_orders import CancelOrders
from .enums import CandleWidth
from .fills_subscription import FillsSubscription, FillsSubscriptionFills
from .get_account_summaries import (
    GetAccountSummaries,
    GetAccountSummariesAccountSummaries,
)
from .get_account_summaries_for_cpty import (
    GetAccountSummariesForCpty,
    GetAccountSummariesForCptyAccountSummariesForCpty,
)
from .get_accounts import GetAccounts, GetAccountsAccounts
from .get_algo_order import GetAlgoOrder, GetAlgoOrderAlgoOrder
from .get_algo_status import GetAlgoStatus, GetAlgoStatusAlgoStatus
from .get_all_market_snapshots import (
    GetAllMarketSnapshots,
    GetAllMarketSnapshotsMarketsSnapshots,
)
from .get_all_open_orders import GetAllOpenOrders, GetAllOpenOrdersOpenOrders
from .get_balances_for_cpty import (
    GetBalancesForCpty,
    GetBalancesForCptyAccountSummariesForCpty,
)
from .get_book_snapshot import GetBookSnapshot, GetBookSnapshotBookSnapshot
from .get_fills import GetFills, GetFillsFills
from .get_filtered_markets import GetFilteredMarkets, GetFilteredMarketsFilterMarkets
from .get_market import GetMarket, GetMarketMarket
from .get_market_snapshot import GetMarketSnapshot, GetMarketSnapshotMarketSnapshot
from .get_markets import GetMarkets, GetMarketsMarkets
from .get_mm_order import GetMmOrder, GetMmOrderMmAlgoOrder
from .get_mm_status import GetMmStatus, GetMmStatusMmAlgoStatus
from .get_order import GetOrder, GetOrderOrder
from .get_out_orders import GetOutOrders, GetOutOrdersOutedOrders
from .get_pov_order import GetPovOrder, GetPovOrderPovOrder
from .get_pov_status import GetPovStatus, GetPovStatusPovStatus
from .get_smart_order_router_order import (
    GetSmartOrderRouterOrder,
    GetSmartOrderRouterOrderSmartOrderRouterOrder,
)
from .get_smart_order_router_status import (
    GetSmartOrderRouterStatus,
    GetSmartOrderRouterStatusSmartOrderRouterStatus,
)
from .get_spread_order import GetSpreadOrder, GetSpreadOrderSpreadAlgoOrder
from .get_spread_status import GetSpreadStatus, GetSpreadStatusSpreadAlgoStatus
from .get_twap_order import GetTwapOrder, GetTwapOrderTwapOrder
from .get_twap_status import GetTwapStatus, GetTwapStatusTwapStatus
from .input_types import (
    CreateMMAlgo,
    CreateOrder,
    CreatePovAlgo,
    CreateSmartOrderRouterAlgo,
    CreateSpreadAlgo,
    CreateTwapAlgo,
)
from .juniper_async_base_client import JuniperAsyncBaseClient
from .preview_smart_order_router_algo_request import (
    PreviewSmartOrderRouterAlgoRequest,
    PreviewSmartOrderRouterAlgoRequestPreviewSmartOrderRouterAlgo,
)
from .remove_telegram_api_keys import RemoveTelegramApiKeys
from .search_markets import SearchMarkets, SearchMarketsFilterMarkets
from .send_mm_algo_request import SendMmAlgoRequest
from .send_order import SendOrder
from .send_orders import SendOrders
from .send_pov_algo_request import SendPovAlgoRequest
from .send_smart_order_router_algo_request import SendSmartOrderRouterAlgoRequest
from .send_spread_algo_request import SendSpreadAlgoRequest
from .send_twap_algo_request import SendTwapAlgoRequest
from .subscribe_book import SubscribeBook, SubscribeBookBook
from .subscribe_candles import SubscribeCandles, SubscribeCandlesCandles
from .subscribe_exchange_specific import (
    SubscribeExchangeSpecific,
    SubscribeExchangeSpecificExchangeSpecific,
)
from .subscribe_orderflow import (
    SubscribeOrderflow,
    SubscribeOrderflowOrderflowAberrantFill,
    SubscribeOrderflowOrderflowAck,
    SubscribeOrderflowOrderflowCancel,
    SubscribeOrderflowOrderflowCancelAll,
    SubscribeOrderflowOrderflowFill,
    SubscribeOrderflowOrderflowOmsOrderUpdate,
    SubscribeOrderflowOrderflowOrder,
    SubscribeOrderflowOrderflowOut,
    SubscribeOrderflowOrderflowReject,
)
from .subscribe_trades import SubscribeTrades, SubscribeTradesTrades


def gql(q: str) -> str:
    return q


class AsyncGraphQLClient(JuniperAsyncBaseClient):
    async def get_market(self, id: Any, **kwargs: Any) -> Optional[GetMarketMarket]:
        query = gql(
            """
            query GetMarket($id: MarketId!) {
              market(id: $id) {
                ...MarketFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="GetMarket", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetMarket.model_validate(data).market

    async def get_markets(
        self, ids: List[Any], **kwargs: Any
    ) -> List[Optional[GetMarketsMarkets]]:
        query = gql(
            """
            query GetMarkets($ids: [MarketId!]!) {
              markets(id: $ids) {
                ...MarketFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=query, operation_name="GetMarkets", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetMarkets.model_validate(data).markets

    async def get_filtered_markets(
        self,
        venue: Union[Optional[Any], UnsetType] = UNSET,
        base: Union[Optional[Any], UnsetType] = UNSET,
        quote: Union[Optional[Any], UnsetType] = UNSET,
        underlying: Union[Optional[Any], UnsetType] = UNSET,
        max_results: Union[Optional[int], UnsetType] = UNSET,
        results_offset: Union[Optional[int], UnsetType] = UNSET,
        search_string: Union[Optional[Any], UnsetType] = UNSET,
        only_favorites: Union[Optional[bool], UnsetType] = UNSET,
        sort_by_volume_desc: Union[Optional[bool], UnsetType] = UNSET,
        **kwargs: Any
    ) -> List[GetFilteredMarketsFilterMarkets]:
        query = gql(
            """
            query GetFilteredMarkets($venue: Str, $base: Str, $quote: Str, $underlying: Str, $maxResults: Int, $resultsOffset: Int, $searchString: Str, $onlyFavorites: Boolean, $sortByVolumeDesc: Boolean) {
              filterMarkets(
                filter: {venue: $venue, base: $base, quote: $quote, underlying: $underlying, maxResults: $maxResults, resultsOffset: $resultsOffset, searchString: $searchString, onlyFavorites: $onlyFavorites, sortByVolumeDesc: $sortByVolumeDesc}
              ) {
                ...MarketFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {
            "venue": venue,
            "base": base,
            "quote": quote,
            "underlying": underlying,
            "maxResults": max_results,
            "resultsOffset": results_offset,
            "searchString": search_string,
            "onlyFavorites": only_favorites,
            "sortByVolumeDesc": sort_by_volume_desc,
        }
        response = await self.execute(
            query=query,
            operation_name="GetFilteredMarkets",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetFilteredMarkets.model_validate(data).filter_markets

    async def search_markets(
        self,
        venue: Union[Optional[Any], UnsetType] = UNSET,
        base: Union[Optional[Any], UnsetType] = UNSET,
        quote: Union[Optional[Any], UnsetType] = UNSET,
        underlying: Union[Optional[Any], UnsetType] = UNSET,
        max_results: Union[Optional[int], UnsetType] = UNSET,
        results_offset: Union[Optional[int], UnsetType] = UNSET,
        search_string: Union[Optional[Any], UnsetType] = UNSET,
        only_favorites: Union[Optional[bool], UnsetType] = UNSET,
        sort_by_volume_desc: Union[Optional[bool], UnsetType] = UNSET,
        **kwargs: Any
    ) -> List[SearchMarketsFilterMarkets]:
        query = gql(
            """
            query SearchMarkets($venue: Str, $base: Str, $quote: Str, $underlying: Str, $maxResults: Int, $resultsOffset: Int, $searchString: Str, $onlyFavorites: Boolean, $sortByVolumeDesc: Boolean) {
              filterMarkets(
                filter: {venue: $venue, base: $base, quote: $quote, underlying: $underlying, maxResults: $maxResults, resultsOffset: $resultsOffset, searchString: $searchString, onlyFavorites: $onlyFavorites, sortByVolumeDesc: $sortByVolumeDesc}
              ) {
                ...MarketFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {
            "venue": venue,
            "base": base,
            "quote": quote,
            "underlying": underlying,
            "maxResults": max_results,
            "resultsOffset": results_offset,
            "searchString": search_string,
            "onlyFavorites": only_favorites,
            "sortByVolumeDesc": sort_by_volume_desc,
        }
        response = await self.execute(
            query=query, operation_name="SearchMarkets", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SearchMarkets.model_validate(data).filter_markets

    async def get_market_snapshot(
        self, id: Any, **kwargs: Any
    ) -> Optional[GetMarketSnapshotMarketSnapshot]:
        query = gql(
            """
            query GetMarketSnapshot($id: MarketId!) {
              marketSnapshot(market: $id) {
                ...MarketSnapshotFields
              }
            }

            fragment MarketSnapshotFields on MarketSnapshot {
              __typename
              marketId
              market {
                name
              }
              high24h
              lastPrice
              low24h
              volume24h
              open24h
              bidPrice
              askPrice
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="GetMarketSnapshot",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetMarketSnapshot.model_validate(data).market_snapshot

    async def get_all_market_snapshots(
        self, **kwargs: Any
    ) -> List[GetAllMarketSnapshotsMarketsSnapshots]:
        query = gql(
            """
            query GetAllMarketSnapshots {
              marketsSnapshots {
                ...MarketSnapshotFields
              }
            }

            fragment MarketSnapshotFields on MarketSnapshot {
              __typename
              marketId
              market {
                name
              }
              high24h
              lastPrice
              low24h
              volume24h
              open24h
              bidPrice
              askPrice
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="GetAllMarketSnapshots",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAllMarketSnapshots.model_validate(data).markets_snapshots

    async def get_account_summaries(
        self, **kwargs: Any
    ) -> List[GetAccountSummariesAccountSummaries]:
        query = gql(
            """
            query GetAccountSummaries {
              accountSummaries {
                ...AccountSummariesFields
              }
            }

            fragment AccountSummariesFields on AccountSummaries {
              snapshotTs
              byAccount {
                account {
                  id
                  name
                }
                balances {
                  product {
                    ...ProductFields
                  }
                  account {
                    id
                    name
                  }
                  venue {
                    id
                    name
                  }
                  amount
                  totalMargin
                  positionMargin
                  purchasingPower
                  cashExcess
                  yesterdayBalance
                }
                positions {
                  account {
                    id
                    name
                  }
                  venue {
                    id
                    name
                  }
                  market {
                    ...MarketFields
                  }
                  dir
                  quantity
                  averagePrice
                  tradeDate
                  tradeTime
                }
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="GetAccountSummaries",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAccountSummaries.model_validate(data).account_summaries

    async def get_account_summaries_for_cpty(
        self, venue: Any, route: Any, **kwargs: Any
    ) -> GetAccountSummariesForCptyAccountSummariesForCpty:
        query = gql(
            """
            query GetAccountSummariesForCpty($venue: VenueId!, $route: RouteId!) {
              accountSummariesForCpty(venue: $venue, route: $route) {
                ...AccountSummariesFields
              }
            }

            fragment AccountSummariesFields on AccountSummaries {
              snapshotTs
              byAccount {
                account {
                  id
                  name
                }
                balances {
                  product {
                    ...ProductFields
                  }
                  account {
                    id
                    name
                  }
                  venue {
                    id
                    name
                  }
                  amount
                  totalMargin
                  positionMargin
                  purchasingPower
                  cashExcess
                  yesterdayBalance
                }
                positions {
                  account {
                    id
                    name
                  }
                  venue {
                    id
                    name
                  }
                  market {
                    ...MarketFields
                  }
                  dir
                  quantity
                  averagePrice
                  tradeDate
                  tradeTime
                }
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"venue": venue, "route": route}
        response = await self.execute(
            query=query,
            operation_name="GetAccountSummariesForCpty",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAccountSummariesForCpty.model_validate(
            data
        ).account_summaries_for_cpty

    async def get_balances_for_cpty(
        self, venue: Any, route: Any, **kwargs: Any
    ) -> GetBalancesForCptyAccountSummariesForCpty:
        query = gql(
            """
            query GetBalancesForCpty($venue: VenueId!, $route: RouteId!) {
              accountSummariesForCpty(venue: $venue, route: $route) {
                snapshotTs
                byAccount {
                  balances {
                    product {
                      ...ProductFields
                    }
                    amount
                  }
                }
              }
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"venue": venue, "route": route}
        response = await self.execute(
            query=query,
            operation_name="GetBalancesForCpty",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetBalancesForCpty.model_validate(data).account_summaries_for_cpty

    async def get_all_open_orders(
        self, **kwargs: Any
    ) -> List[GetAllOpenOrdersOpenOrders]:
        query = gql(
            """
            query GetAllOpenOrders {
              openOrders {
                ...OrderLogFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment OrderLogFields on OrderLog {
              __typename
              timestamp
              order {
                id
                market {
                  ...MarketFields
                }
                dir
                quantity
                orderType {
                  __typename
                  ... on LimitOrderType {
                    limitPrice
                  }
                  ... on StopLossLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                  ... on TakeProfitLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                }
              }
              orderState
              filledQty
              avgFillPrice
              rejectReason
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="GetAllOpenOrders",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAllOpenOrders.model_validate(data).open_orders

    async def get_out_orders(
        self, from_inclusive: Any, to_exclusive: Any, **kwargs: Any
    ) -> List[GetOutOrdersOutedOrders]:
        query = gql(
            """
            query GetOutOrders($fromInclusive: DateTime!, $toExclusive: DateTime!) {
              outedOrders(fromInclusive: $fromInclusive, toExclusive: $toExclusive) {
                ...OrderLogFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment OrderLogFields on OrderLog {
              __typename
              timestamp
              order {
                id
                market {
                  ...MarketFields
                }
                dir
                quantity
                orderType {
                  __typename
                  ... on LimitOrderType {
                    limitPrice
                  }
                  ... on StopLossLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                  ... on TakeProfitLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                }
              }
              orderState
              filledQty
              avgFillPrice
              rejectReason
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {
            "fromInclusive": from_inclusive,
            "toExclusive": to_exclusive,
        }
        response = await self.execute(
            query=query, operation_name="GetOutOrders", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetOutOrders.model_validate(data).outed_orders

    async def get_order(self, order_id: Any, **kwargs: Any) -> Optional[GetOrderOrder]:
        query = gql(
            """
            query GetOrder($orderId: OrderId!) {
              order(orderId: $orderId) {
                ...OrderLogFields
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment OrderLogFields on OrderLog {
              __typename
              timestamp
              order {
                id
                market {
                  ...MarketFields
                }
                dir
                quantity
                orderType {
                  __typename
                  ... on LimitOrderType {
                    limitPrice
                  }
                  ... on StopLossLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                  ... on TakeProfitLimitOrderType {
                    limitPrice
                    triggerPrice
                  }
                }
              }
              orderState
              filledQty
              avgFillPrice
              rejectReason
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetOrder.model_validate(data).order

    async def get_algo_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetAlgoStatusAlgoStatus]:
        query = gql(
            """
            query GetAlgoStatus($orderId: OrderId!) {
              algoStatus(orderId: $orderId) {
                orderId
                order {
                  orderId
                  trader
                  account
                  algo
                  parentOrderId
                  markets
                }
                creationTime
                status
                lastStatusChange
                fractionComplete
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetAlgoStatus", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetAlgoStatus.model_validate(data).algo_status

    async def get_algo_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetAlgoOrderAlgoOrder]:
        query = gql(
            """
            query GetAlgoOrder($orderId: OrderId!) {
              algoOrder(orderId: $orderId) {
                orderId
                trader
                account
                algo
                parentOrderId
                markets
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetAlgoOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetAlgoOrder.model_validate(data).algo_order

    async def get_twap_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetTwapStatusTwapStatus]:
        query = gql(
            """
            query GetTwapStatus($orderId: OrderId!) {
              twapStatus(orderId: $orderId) {
                orderId
                order {
                  name
                  orderId
                  marketId
                  dir
                  quantity
                  endTime
                  accountId
                  intervalMs
                  rejectLockoutMs
                  takeThroughFrac
                }
                creationTime
                status
                fractionComplete
                realizedTwap
                quantityFilled
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetTwapStatus", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetTwapStatus.model_validate(data).twap_status

    async def get_twap_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetTwapOrderTwapOrder]:
        query = gql(
            """
            query GetTwapOrder($orderId: OrderId!) {
              twapOrder(orderId: $orderId) {
                name
                orderId
                marketId
                dir
                quantity
                endTime
                accountId
                intervalMs
                rejectLockoutMs
                takeThroughFrac
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetTwapOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetTwapOrder.model_validate(data).twap_order

    async def get_pov_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetPovStatusPovStatus]:
        query = gql(
            """
            query GetPovStatus($orderId: OrderId!) {
              povStatus(orderId: $orderId) {
                orderId
                order {
                  name
                  orderId
                  marketId
                  dir
                  targetVolumeFrac
                  minOrderQuantity
                  maxQuantity
                  endTime
                  accountId
                  takeThroughFrac
                }
                creationTime
                status
                fractionComplete
                realizedVolumeFrac
                marketVolume
                quantityFilled
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetPovStatus", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetPovStatus.model_validate(data).pov_status

    async def get_pov_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetPovOrderPovOrder]:
        query = gql(
            """
            query GetPovOrder($orderId: OrderId!) {
              povOrder(orderId: $orderId) {
                name
                orderId
                marketId
                dir
                targetVolumeFrac
                minOrderQuantity
                maxQuantity
                endTime
                accountId
                takeThroughFrac
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetPovOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetPovOrder.model_validate(data).pov_order

    async def get_smart_order_router_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetSmartOrderRouterStatusSmartOrderRouterStatus]:
        query = gql(
            """
            query GetSmartOrderRouterStatus($orderId: OrderId!) {
              smartOrderRouterStatus(orderId: $orderId) {
                status {
                  orderId
                  order {
                    orderId
                    trader
                    account
                    algo
                    parentOrderId
                    markets
                  }
                  creationTime
                  status
                  lastStatusChange
                  fractionComplete
                }
                order {
                  orderId
                  markets {
                    id
                  }
                  dir
                  limitPrice
                  targetSize
                  executionTimeLimitMs
                  parentOrderId
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query,
            operation_name="GetSmartOrderRouterStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetSmartOrderRouterStatus.model_validate(data).smart_order_router_status

    async def get_smart_order_router_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetSmartOrderRouterOrderSmartOrderRouterOrder]:
        query = gql(
            """
            query GetSmartOrderRouterOrder($orderId: OrderId!) {
              smartOrderRouterOrder(orderId: $orderId) {
                orderId
                markets {
                  id
                }
                dir
                limitPrice
                targetSize
                executionTimeLimitMs
                parentOrderId
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query,
            operation_name="GetSmartOrderRouterOrder",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetSmartOrderRouterOrder.model_validate(data).smart_order_router_order

    async def get_mm_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetMmStatusMmAlgoStatus]:
        query = gql(
            """
            query GetMmStatus($orderId: OrderId!) {
              mmAlgoStatus(orderId: $orderId) {
                orderId
                order {
                  name
                  orderId
                  marketId
                  quantityBuy
                  quantitySell
                  minPosition
                  maxPosition
                  maxImproveBbo
                  positionTilt
                  referencePrice
                  refDistFrac
                  toleranceFrac
                  account
                }
                creationTime
                status
                position
                hedgePosition
                missRatio
                effectiveSpread
                buyStatus {
                  lastOrderTime
                  lastFillTime
                  lastRejectTime
                  openOrder {
                    orderId
                    price
                    quantity
                    cancelPending
                  }
                  referencePrice
                }
                sellStatus {
                  lastOrderTime
                  lastFillTime
                  lastRejectTime
                  openOrder {
                    orderId
                    price
                    quantity
                    cancelPending
                  }
                  referencePrice
                }
                kind
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetMmStatus", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetMmStatus.model_validate(data).mm_algo_status

    async def get_mm_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetMmOrderMmAlgoOrder]:
        query = gql(
            """
            query GetMmOrder($orderId: OrderId!) {
              mmAlgoOrder(orderId: $orderId) {
                name
                orderId
                marketId
                quantityBuy
                quantitySell
                minPosition
                maxPosition
                maxImproveBbo
                positionTilt
                referencePrice
                refDistFrac
                toleranceFrac
                account
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetMmOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetMmOrder.model_validate(data).mm_algo_order

    async def get_spread_status(
        self, order_id: Any, **kwargs: Any
    ) -> List[GetSpreadStatusSpreadAlgoStatus]:
        query = gql(
            """
            query GetSpreadStatus($orderId: OrderId!) {
              spreadAlgoStatus(orderId: $orderId) {
                orderId
                order {
                  name
                  orderId
                  marketId
                  quantityBuy
                  quantitySell
                  minPosition
                  maxPosition
                  maxImproveBbo
                  positionTilt
                  referencePrice
                  refDistFrac
                  toleranceFrac
                  account
                }
                creationTime
                status
                position
                hedgePosition
                missRatio
                effectiveSpread
                buyStatus {
                  lastOrderTime
                  lastFillTime
                  lastRejectTime
                  openOrder {
                    orderId
                    price
                    quantity
                    cancelPending
                  }
                  referencePrice
                }
                sellStatus {
                  lastOrderTime
                  lastFillTime
                  lastRejectTime
                  openOrder {
                    orderId
                    price
                    quantity
                    cancelPending
                  }
                  referencePrice
                }
                kind
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetSpreadStatus", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetSpreadStatus.model_validate(data).spread_algo_status

    async def get_spread_order(
        self, order_id: Any, **kwargs: Any
    ) -> Optional[GetSpreadOrderSpreadAlgoOrder]:
        query = gql(
            """
            query GetSpreadOrder($orderId: OrderId!) {
              spreadAlgoOrder(orderId: $orderId) {
                name
                orderId
                marketId
                quantityBuy
                quantitySell
                minPosition
                maxPosition
                maxImproveBbo
                positionTilt
                referencePrice
                refDistFrac
                toleranceFrac
                account
              }
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="GetSpreadOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetSpreadOrder.model_validate(data).spread_algo_order

    async def get_fills(
        self,
        venue: Union[Optional[Any], UnsetType] = UNSET,
        route: Union[Optional[Any], UnsetType] = UNSET,
        base: Union[Optional[Any], UnsetType] = UNSET,
        quote: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetFillsFills:
        query = gql(
            """
            query GetFills($venue: VenueId, $route: RouteId, $base: ProductId, $quote: ProductId) {
              fills(venue: $venue, route: $route, base: $base, quote: $quote) {
                normal {
                  kind
                  fillId
                  orderId
                  market {
                    ...MarketFields
                  }
                  dir
                  price
                  quantity
                  recvTime
                  tradeTime
                }
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {
            "venue": venue,
            "route": route,
            "base": base,
            "quote": quote,
        }
        response = await self.execute(
            query=query, operation_name="GetFills", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetFills.model_validate(data).fills

    async def subscribe_trades(
        self, market: Any, **kwargs: Any
    ) -> AsyncIterator[SubscribeTradesTrades]:
        query = gql(
            """
            subscription SubscribeTrades($market: MarketId!) {
              trades(market: $market) {
                time
                price
                size
                direction
              }
            }
            """
        )
        variables: Dict[str, object] = {"market": market}
        async for data in self.execute_ws(
            query=query, operation_name="SubscribeTrades", variables=variables, **kwargs
        ):
            yield SubscribeTrades.model_validate(data).trades

    async def subscribe_candles(
        self, id: Any, width: CandleWidth, **kwargs: Any
    ) -> AsyncIterator[SubscribeCandlesCandles]:
        query = gql(
            """
            subscription SubscribeCandles($id: MarketId!, $width: CandleWidth!) {
              candles(market: $id, candleWidth: $width) {
                ...CandleFields
              }
            }

            fragment CandleFields on CandleV1 {
              time
              open
              high
              low
              close
              volume
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "width": width}
        async for data in self.execute_ws(
            query=query,
            operation_name="SubscribeCandles",
            variables=variables,
            **kwargs
        ):
            yield SubscribeCandles.model_validate(data).candles

    async def fills_subscription(
        self, **kwargs: Any
    ) -> AsyncIterator[FillsSubscriptionFills]:
        query = gql(
            """
            subscription FillsSubscription {
              fills {
                dir
                fillId
                kind
                marketId
                orderId
                price
                quantity
                recvTime
                tradeTime
                market {
                  ...MarketFields
                }
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {}
        async for data in self.execute_ws(
            query=query,
            operation_name="FillsSubscription",
            variables=variables,
            **kwargs
        ):
            yield FillsSubscription.model_validate(data).fills

    async def subscribe_book(
        self, id: Any, precision: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> AsyncIterator[SubscribeBookBook]:
        query = gql(
            """
            subscription SubscribeBook($id: MarketId!, $precision: Decimal) {
              book(market: $id, precision: $precision) {
                bids {
                  price
                  amount
                  total
                }
                asks {
                  price
                  amount
                  total
                }
                timestamp
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "precision": precision}
        async for data in self.execute_ws(
            query=query, operation_name="SubscribeBook", variables=variables, **kwargs
        ):
            yield SubscribeBook.model_validate(data).book

    async def subscribe_exchange_specific(
        self, markets: List[Any], fields: List[str], **kwargs: Any
    ) -> AsyncIterator[List[SubscribeExchangeSpecificExchangeSpecific]]:
        query = gql(
            """
            subscription SubscribeExchangeSpecific($markets: [MarketId!]!, $fields: [String!]!) {
              exchangeSpecific(markets: $markets, fields: $fields) {
                market {
                  ...MarketFields
                }
                field
                value
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"markets": markets, "fields": fields}
        async for data in self.execute_ws(
            query=query,
            operation_name="SubscribeExchangeSpecific",
            variables=variables,
            **kwargs
        ):
            yield SubscribeExchangeSpecific.model_validate(data).exchange_specific

    async def send_order(self, order: CreateOrder, **kwargs: Any) -> Any:
        query = gql(
            """
            mutation SendOrder($order: CreateOrder!) {
              createOrder(order: $order)
            }
            """
        )
        variables: Dict[str, object] = {"order": order}
        response = await self.execute(
            query=query, operation_name="SendOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SendOrder.model_validate(data).create_order

    async def send_orders(self, orders: List[CreateOrder], **kwargs: Any) -> List[Any]:
        query = gql(
            """
            mutation SendOrders($orders: [CreateOrder!]!) {
              createOrders(orders: $orders)
            }
            """
        )
        variables: Dict[str, object] = {"orders": orders}
        response = await self.execute(
            query=query, operation_name="SendOrders", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SendOrders.model_validate(data).create_orders

    async def send_twap_algo_request(self, algo: CreateTwapAlgo, **kwargs: Any) -> Any:
        query = gql(
            """
            mutation SendTwapAlgoRequest($algo: CreateTwapAlgo!) {
              createTwapAlgo(twapAlgo: $algo)
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="SendTwapAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SendTwapAlgoRequest.model_validate(data).create_twap_algo

    async def send_pov_algo_request(self, algo: CreatePovAlgo, **kwargs: Any) -> Any:
        query = gql(
            """
            mutation SendPovAlgoRequest($algo: CreatePovAlgo!) {
              createPovAlgo(povAlgo: $algo)
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="SendPovAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SendPovAlgoRequest.model_validate(data).create_pov_algo

    async def preview_smart_order_router_algo_request(
        self, algo: CreateSmartOrderRouterAlgo, **kwargs: Any
    ) -> Optional[PreviewSmartOrderRouterAlgoRequestPreviewSmartOrderRouterAlgo]:
        query = gql(
            """
            mutation PreviewSmartOrderRouterAlgoRequest($algo: CreateSmartOrderRouterAlgo!) {
              previewSmartOrderRouterAlgo(algo: $algo) {
                orders {
                  ...OrderFields
                }
              }
            }

            fragment MarketFields on Market {
              __typename
              venue {
                id
                name
              }
              exchangeSymbol
              id
              cmeProductGroupInfo {
                productName
                securityType
                category
                subCategory
                mainFraction
              }
              kind {
                ... on ExchangeMarketKind {
                  __typename
                  base {
                    ...ProductFields
                  }
                  quote {
                    ...ProductFields
                  }
                }
                ... on PoolMarketKind {
                  __typename
                  products {
                    ...ProductFields
                  }
                }
              }
              name
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              route {
                id
                name
              }
              isFavorite
            }

            fragment OrderFields on Order {
              id
              marketId
              market {
                ...MarketFields
              }
              dir
              quantity
              accountId
              orderType {
                __typename
                ... on LimitOrderType {
                  limitPrice
                  postOnly
                }
                ... on StopLossLimitOrderType {
                  limitPrice
                  triggerPrice
                }
                ... on TakeProfitLimitOrderType {
                  limitPrice
                  triggerPrice
                }
              }
              timeInForce {
                instruction
                goodTilDate
              }
              quoteId
              source
            }

            fragment ProductFields on Product {
              __typename
              id
              name
              kind
              markUsd
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="PreviewSmartOrderRouterAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return PreviewSmartOrderRouterAlgoRequest.model_validate(
            data
        ).preview_smart_order_router_algo

    async def send_smart_order_router_algo_request(
        self, algo: CreateSmartOrderRouterAlgo, **kwargs: Any
    ) -> Any:
        query = gql(
            """
            mutation SendSmartOrderRouterAlgoRequest($algo: CreateSmartOrderRouterAlgo!) {
              createSmartOrderRouterAlgo(algo: $algo)
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="SendSmartOrderRouterAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SendSmartOrderRouterAlgoRequest.model_validate(
            data
        ).create_smart_order_router_algo

    async def send_mm_algo_request(self, algo: CreateMMAlgo, **kwargs: Any) -> Any:
        query = gql(
            """
            mutation SendMmAlgoRequest($algo: CreateMMAlgo!) {
              createMmAlgo(mmAlgo: $algo)
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="SendMmAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SendMmAlgoRequest.model_validate(data).create_mm_algo

    async def send_spread_algo_request(
        self, algo: CreateSpreadAlgo, **kwargs: Any
    ) -> Any:
        query = gql(
            """
            mutation SendSpreadAlgoRequest($algo: CreateSpreadAlgo!) {
              createSpreadAlgo(spreadAlgo: $algo)
            }
            """
        )
        variables: Dict[str, object] = {"algo": algo}
        response = await self.execute(
            query=query,
            operation_name="SendSpreadAlgoRequest",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SendSpreadAlgoRequest.model_validate(data).create_spread_algo

    async def cancel_order(self, order_id: Any, **kwargs: Any) -> Any:
        query = gql(
            """
            mutation CancelOrder($orderId: OrderId!) {
              cancelOrder(orderId: $orderId)
            }
            """
        )
        variables: Dict[str, object] = {"orderId": order_id}
        response = await self.execute(
            query=query, operation_name="CancelOrder", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CancelOrder.model_validate(data).cancel_order

    async def cancel_orders(self, order_ids: List[Any], **kwargs: Any) -> List[Any]:
        query = gql(
            """
            mutation CancelOrders($orderIds: [OrderId!]!) {
              cancelOrders(orderIds: $orderIds)
            }
            """
        )
        variables: Dict[str, object] = {"orderIds": order_ids}
        response = await self.execute(
            query=query, operation_name="CancelOrders", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CancelOrders.model_validate(data).cancel_orders

    async def cancel_all_orders(
        self, venue: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> Optional[Any]:
        query = gql(
            """
            mutation CancelAllOrders($venue: VenueId) {
              cancelAllOrders(venueId: $venue)
            }
            """
        )
        variables: Dict[str, object] = {"venue": venue}
        response = await self.execute(
            query=query, operation_name="CancelAllOrders", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CancelAllOrders.model_validate(data).cancel_all_orders

    async def remove_telegram_api_keys(self, **kwargs: Any) -> bool:
        query = gql(
            """
            mutation RemoveTelegramApiKeys {
              removeTelegramApiKeys
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="RemoveTelegramApiKeys",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RemoveTelegramApiKeys.model_validate(data).remove_telegram_api_keys

    async def subscribe_orderflow(self, **kwargs: Any) -> AsyncIterator[
        Union[
            SubscribeOrderflowOrderflowOrder,
            SubscribeOrderflowOrderflowOmsOrderUpdate,
            SubscribeOrderflowOrderflowCancel,
            SubscribeOrderflowOrderflowCancelAll,
            SubscribeOrderflowOrderflowAck,
            SubscribeOrderflowOrderflowReject,
            SubscribeOrderflowOrderflowFill,
            SubscribeOrderflowOrderflowAberrantFill,
            SubscribeOrderflowOrderflowOut,
        ]
    ]:
        query = gql(
            """
            subscription SubscribeOrderflow {
              orderflow {
                __typename
                ... on Order {
                  id
                  marketId
                  dir
                  quantity
                  accountId
                  orderType {
                    __typename
                    ... on LimitOrderType {
                      limitPrice
                      postOnly
                    }
                    ... on StopLossLimitOrderType {
                      limitPrice
                      triggerPrice
                    }
                    ... on TakeProfitLimitOrderType {
                      limitPrice
                      triggerPrice
                    }
                  }
                  timeInForce {
                    instruction
                    goodTilDate
                  }
                  quoteId
                  source
                }
                ... on Ack {
                  orderId
                }
                ... on Reject {
                  orderId
                  reason
                }
                ... on OmsOrderUpdate {
                  orderId
                  orderState: state
                  filledQty
                  avgFillPrice
                }
                ... on Fill {
                  fillOrderId: orderId
                  fillKind: kind
                  marketId
                  dir
                  price
                  quantity
                  tradeTime
                }
                ... on Out {
                  orderId
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        async for data in self.execute_ws(
            query=query,
            operation_name="SubscribeOrderflow",
            variables=variables,
            **kwargs
        ):
            yield SubscribeOrderflow.model_validate(data).orderflow

    async def get_book_snapshot(
        self,
        market: Any,
        num_levels: int,
        precision: Union[Optional[Any], UnsetType] = UNSET,
        retain_seconds: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetBookSnapshotBookSnapshot:
        query = gql(
            """
            query GetBookSnapshot($market: MarketId!, $numLevels: Int!, $precision: Decimal, $retainSeconds: Int) {
              bookSnapshot(
                market: $market
                numLevels: $numLevels
                precision: $precision
                retainSubscriptionForNSeconds: $retainSeconds
              ) {
                timestamp
                bids {
                  price
                  amount
                  total
                }
                asks {
                  price
                  amount
                  total
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "market": market,
            "numLevels": num_levels,
            "precision": precision,
            "retainSeconds": retain_seconds,
        }
        response = await self.execute(
            query=query, operation_name="GetBookSnapshot", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetBookSnapshot.model_validate(data).book_snapshot

    async def get_accounts(self, **kwargs: Any) -> List[GetAccountsAccounts]:
        query = gql(
            """
            query GetAccounts {
              accounts {
                id
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="GetAccounts", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetAccounts.model_validate(data).accounts
