import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface ClusterProps {
    /**
     * VPC.
     *
     * @default - create new VPC
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Run worker nodes as EC2 Spot.
     *
     * @default true
     * @stability stable
     */
    readonly spotWorkerNodes?: boolean;
    /**
     * control plane node ec2 instance type.
     *
     * @default mg6.medium
     * @stability stable
     */
    readonly controlPlaneInstanceType?: ec2.InstanceType;
    /**
     * worker node instance type.
     *
     * @default mg6.medium
     * @stability stable
     */
    readonly workerInstanceType?: ec2.InstanceType;
    /**
     * minimal number of worker nodes.
     *
     * @default 3
     * @stability stable
     */
    readonly workerMinCapacity?: number;
    /**
     * The bucket removal policy.
     *
     * When specicified as `DESTROY`, the S3 bucket for the cluster state
     * will be completely removed on stack destroy.
     *
     * @default - cdk.RemovalPolicy.RETAIN
     * @stability stable
     */
    readonly bucketRemovalPolicy?: cdk.RemovalPolicy;
}
/**
 * Represents the k3sCluster construct.
 *
 * @stability stable
 */
export declare class Cluster extends cdk.Construct {
    /**
     * The instance type of the control plane.
     *
     * @stability stable
     */
    readonly controlPlaneInstanceType: ec2.InstanceType;
    /**
     * The instance type of the worker node.
     *
     * @stability stable
     */
    readonly workerInstanceType: ec2.InstanceType;
    /**
     * The endpoint URL of the control plan.
     *
     * @stability stable
     */
    readonly endpointUri: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: ClusterProps);
}
/**
 * The AMI provider to get the latest Amazon Linux 2 AMI for ARM64.
 *
 * @stability stable
 */
export declare class AmiProvider {
    /**
     * @stability stable
     */
    get amiId(): ec2.IMachineImage;
}
/**
 * The VPC provider to create or import the VPC.
 *
 * @stability stable
 */
export declare class VpcProvider {
    /**
     * @stability stable
     */
    static getOrCreate(scope: cdk.Construct): ec2.IVpc;
}
