/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.FGrowArray;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.sparse.csc.misc.ImplCommonOps_MT_FSCC;
import org.ejml.sparse.csc.mult.ImplMultiplication_MT_FSCC;
import org.ejml.sparse.csc.mult.Workspace_MT_FSCC;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class CommonOps_MT_FSCC {
    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC) {
        return CommonOps_MT_FSCC.mult(A2, B, outputC, null);
    }

    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_FSCC> listWork) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, B.numCols);
        if (listWork == null) {
            listWork = new GrowArray<Workspace_MT_FSCC>(Workspace_MT_FSCC::new);
        }
        ImplMultiplication_MT_FSCC.mult(A2, B, outputC, listWork);
        return outputC;
    }

    public static FMatrixSparseCSC add(float alpha, FMatrixSparseCSC A2, float beta, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_FSCC> listWork) {
        if (A2.numRows != B.numRows || A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, A2.numCols);
        if (listWork == null) {
            listWork = new GrowArray<Workspace_MT_FSCC>(Workspace_MT_FSCC::new);
        }
        ImplCommonOps_MT_FSCC.add(alpha, A2, beta, B, outputC, listWork);
        return outputC;
    }

    public static FMatrixRMaj mult(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArrays) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numCols);
        if (workArrays == null) {
            workArrays = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.mult(A2, B, outputC, workArrays);
        return outputC;
    }

    public static void multAdd(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArrays) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArrays == null) {
            workArrays = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.multAdd(A2, B, outputC, workArrays);
    }

    public static FMatrixRMaj multTransA(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArray) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numCols);
        if (workArray == null) {
            workArray = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.multTransA(A2, B, outputC, workArray);
        return outputC;
    }

    public static void multAddTransA(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArray) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArray == null) {
            workArray = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.multAddTransA(A2, B, outputC, workArray);
    }

    public static FMatrixRMaj multTransB(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArrays) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numRows);
        if (workArrays == null) {
            workArrays = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.multTransB(A2, B, outputC, workArrays);
        return outputC;
    }

    public static void multAddTransB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC, @Nullable GrowArray<FGrowArray> workArrays) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArrays == null) {
            workArrays = new GrowArray<FGrowArray>(FGrowArray::new);
        }
        ImplMultiplication_MT_FSCC.multAddTransB(A2, B, outputC, workArrays);
    }

    public static FMatrixRMaj multTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numRows);
        ImplMultiplication_MT_FSCC.multTransAB(A2, B, outputC);
        return outputC;
    }

    public static void multAddTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        ImplMultiplication_MT_FSCC.multAddTransAB(A2, B, outputC);
    }
}

