/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition;

import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.jetbrains.annotations.Nullable;

public class UtilDecompositons_FDRM {
    public static FMatrixRMaj ensureIdentity(@Nullable FMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return CommonOps_FDRM.identity(numRows, numCols);
        }
        A2.reshape(numRows, numCols);
        CommonOps_FDRM.setIdentity(A2);
        return A2;
    }

    public static FMatrixRMaj ensureZeros(@Nullable FMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        A2.reshape(numRows, numCols);
        A2.zero();
        return A2;
    }

    public static FMatrixRMaj checkZerosLT(@Nullable FMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            A2.reshape(numRows, numCols);
            A2.zero();
        } else {
            for (int i = 0; i < A2.numRows; ++i) {
                int index = i * A2.numCols;
                int end = index + Math.min(i, A2.numCols);
                while (index < end) {
                    A2.data[index++] = 0.0f;
                }
            }
        }
        return A2;
    }

    public static FMatrixRMaj checkZerosUT(@Nullable FMatrixRMaj A2, int numRows, int numCols) {
        if (A2 == null) {
            return new FMatrixRMaj(numRows, numCols);
        }
        if (numRows != A2.numRows || numCols != A2.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A2.numRows, A2.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = i * A2.numCols + i + 1;
            int end = i * A2.numCols + A2.numCols;
            while (index < end) {
                A2.data[index++] = 0.0f;
            }
        }
        return A2;
    }
}

