/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.io.Serializable;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public abstract class FastAccess<T>
implements Serializable {
    public T[] data;
    public int size;
    public final Class<T> type;

    protected FastAccess(Class<T> type) {
        this.type = type;
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        return this.data[index];
    }

    public boolean isIndexOutOfBounds(int index) {
        return index < 0 || index >= this.size;
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public abstract T remove(int var1);

    public abstract T removeSwap(int var1);

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract List<T> toList();

    public T getTail() {
        return this.data[this.size - 1];
    }

    public T getTail(int index) {
        return this.data[this.size - 1 - index];
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(T obj) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void reverse() {
        for (int i = 0; i < this.size / 2; ++i) {
            T tmp = this.data[i];
            this.data[i] = this.data[this.size - i - 1];
            this.data[this.size - i - 1] = tmp;
        }
    }

    public void swap(int i, int j) {
        T tmp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = tmp;
    }

    public int findIdx(FunctionMatches<T> function) {
        for (int i = 0; i < this.size; ++i) {
            if (!function.process(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public T find(FunctionMatches<T> function) {
        int match = this.findIdx(function);
        if (match < 0) {
            return null;
        }
        return this.data[match];
    }

    public boolean findAllIdx(DogArray_I32 matches, FunctionMatches<T> function) {
        matches.reset();
        for (int i = 0; i < this.size; ++i) {
            if (!function.process(this.data[i])) continue;
            matches.add(i);
        }
        return !matches.isEmpty();
    }

    public boolean findAll(List<T> matches, FunctionMatches<T> function) {
        matches.clear();
        for (int i = 0; i < this.size; ++i) {
            if (!function.process(this.data[i])) continue;
            matches.add(this.data[i]);
        }
        return !matches.isEmpty();
    }

    public void forIdx(FunctionEachIdx<T> function) {
        for (int i = 0; i < this.size; ++i) {
            function.process(i, this.data[i]);
        }
    }

    public void forIdx(int idx0, int idx1, FunctionEachIdx<T> function) {
        if (idx1 > this.size) {
            throw new IllegalArgumentException("idx1 is out of range");
        }
        for (int i = idx0; i < idx1; ++i) {
            function.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach<T> function) {
        for (int i = 0; i < this.size; ++i) {
            function.process(this.data[i]);
        }
    }

    public void forEach(int idx0, int idx1, FunctionEach<T> function) {
        if (idx1 > this.size) {
            throw new IllegalArgumentException("idx1 is out of range");
        }
        for (int i = idx0; i < idx1; ++i) {
            function.process(this.data[i]);
        }
    }

    @FunctionalInterface
    public static interface FunctionMatches<T> {
        public boolean process(T var1);
    }

    @FunctionalInterface
    public static interface FunctionEachIdx<T> {
        public void process(int var1, T var2);
    }

    @FunctionalInterface
    public static interface FunctionEach<T> {
        public void process(T var1);
    }
}

