/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.struct.DogArrayPrimitive;
import org.ddogleg.struct.DogLambdas;

public class DogArray_F64
implements DogArrayPrimitive<DogArray_F64> {
    public double[] data;
    public int size;

    public DogArray_F64(int reserve) {
        this.data = new double[reserve];
        this.size = 0;
    }

    public DogArray_F64() {
        this(10);
    }

    public static DogArray_F64 zeros(int length) {
        DogArray_F64 out = new DogArray_F64(length);
        out.size = length;
        return out;
    }

    public static DogArray_F64 array(double ... values) {
        DogArray_F64 out = DogArray_F64.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static DogArray_F64 range(int idx0, int idx1) {
        DogArray_F64 out = DogArray_F64.zeros(idx1 - idx0);
        for (int i = idx0; i < idx1; ++i) {
            out.data[i - idx0] = i;
        }
        return out;
    }

    public int count(double value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(double ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(DogArray_F64 queue) {
        if (this.size + queue.size > this.data.length) {
            double[] temp = new double[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(double[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array. " + endIndex + " > " + array.length);
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            double[] temp = new double[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(double val) {
        this.push(val);
    }

    public void push(double val) {
        if (this.size == this.data.length) {
            double[] temp;
            try {
                temp = new double[this.size * 2 + 5];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new double[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public void setTo(double[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public DogArray_F64 setTo(double ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public double[] toArray() {
        double[] out = new double[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last. first=" + first + " last=" + last);
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size. last=" + last + " size=" + this.size);
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, double value) {
        if (this.size == this.data.length) {
            double[] temp = new double[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public double removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        double ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public double removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public double getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.data[this.size - 1];
    }

    public double getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public void setTail(int index, double value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        this.data[this.size - index - 1] = value;
    }

    public double getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public double unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, double value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(DogArray_F64 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    @Override
    public void resize(int size) {
        this.reserve(size);
        this.size = size;
    }

    public void resize(int size, double value) {
        int priorSize = this.size;
        this.resize(size);
        if (priorSize >= size) {
            return;
        }
        this.fill(priorSize, size, value);
    }

    public void resetResize(int size, double value) {
        this.reset();
        this.resize(size, value);
    }

    public void resize(int size, DogLambdas.AssignIdx_F64 op) {
        int priorSize = this.size;
        this.resize(size);
        for (int i = priorSize; i < size; ++i) {
            this.data[i] = op.assign(i);
        }
    }

    public void fill(double value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, double value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(double value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        if (this.size == 0) {
            this.data = null;
            this.data = new double[amount];
        } else {
            double[] tmp = new double[amount];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, 0.0);
    }

    @Override
    public DogArray_F64 copy() {
        DogArray_F64 ret = new DogArray_F64(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            double tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public double pop() {
        return this.data[--this.size];
    }

    public int indexOf(double value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfGreatest() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        double best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] > best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    public int indexOfLeast() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        double best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] < best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void sort(QuickSort_F64 sorter) {
        sorter.sort(this.data, this.size);
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    public int count(Filter filter) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.include(this.data[i])) continue;
            ++total;
        }
        return total;
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, double var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(double var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public double process(int var1, double var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean include(double var1);
    }
}

