/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.DogArrayPrimitive;
import org.ddogleg.struct.DogLambdas;

public class DogArray_B
implements DogArrayPrimitive<DogArray_B> {
    public boolean[] data;
    public int size;

    public DogArray_B(int reserve) {
        this.data = new boolean[reserve];
        this.size = 0;
    }

    public DogArray_B() {
        this(10);
    }

    public static DogArray_B zeros(int length) {
        DogArray_B out = new DogArray_B(length);
        out.size = length;
        return out;
    }

    public static DogArray_B array(boolean ... values) {
        DogArray_B out = DogArray_B.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static DogArray_B array(int ... values) {
        DogArray_B out = DogArray_B.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i] != 0;
        }
        return out;
    }

    public int count(boolean value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(int ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            boolean v;
            boolean bl = v = values[i] != 0;
            if (this.data[i] == v) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(boolean ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(DogArray_B queue) {
        if (this.size + queue.size > this.data.length) {
            boolean[] temp = new boolean[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(boolean[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array. " + endIndex + " > " + array.length);
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            boolean[] temp = new boolean[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(boolean val) {
        this.push(val);
    }

    public void push(boolean val) {
        if (this.size == this.data.length) {
            boolean[] temp;
            try {
                temp = new boolean[this.size * 2 + 5];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new boolean[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public void setTo(boolean[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public DogArray_B setTo(boolean ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public boolean[] toArray() {
        boolean[] out = new boolean[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last. first=" + first + " last=" + last);
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size. last=" + last + " size=" + this.size);
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, boolean value) {
        if (this.size == this.data.length) {
            boolean[] temp = new boolean[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public boolean removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        boolean ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public boolean removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public boolean getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.data[this.size - 1];
    }

    public boolean getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public void setTail(int index, boolean value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        this.data[this.size - index - 1] = value;
    }

    public boolean unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(DogArray_B original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    @Override
    public void resize(int size) {
        this.reserve(size);
        this.size = size;
    }

    public void resize(int size, boolean value) {
        int priorSize = this.size;
        this.resize(size);
        if (priorSize >= size) {
            return;
        }
        this.fill(priorSize, size, value);
    }

    public void resetResize(int size, boolean value) {
        this.reset();
        this.resize(size, value);
    }

    public void resize(int size, DogLambdas.AssignIdx_B op) {
        int priorSize = this.size;
        this.resize(size);
        for (int i = priorSize; i < size; ++i) {
            this.data[i] = op.assign(i);
        }
    }

    public void fill(boolean value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, boolean value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(boolean value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        if (this.size == 0) {
            this.data = null;
            this.data = new boolean[amount];
        } else {
            boolean[] tmp = new boolean[amount];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, false);
    }

    @Override
    public DogArray_B copy() {
        DogArray_B ret = new DogArray_B(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            boolean tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public boolean pop() {
        return this.data[--this.size];
    }

    public int indexOf(boolean value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        throw new RuntimeException("Undefined for boolean");
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, boolean var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(boolean var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public boolean process(int var1, boolean var2);
    }
}

