/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.ddogleg.struct.DogArray;

public class DogArrayList<T>
implements List<T>,
Serializable {
    DogArray<T> array;

    public DogArrayList(DogArray<T> array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.size;
    }

    @Override
    public boolean isEmpty() {
        return this.array.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.array.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.array.size];
        System.arraycopy(this.array.data, 0, ret, 0, this.array.size);
        return ret;
    }

    @Override
    public <A> A[] toArray(A[] a) {
        System.arraycopy(this.array.data, 0, a, 0, this.array.size);
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new RuntimeException("Add is not supported by FastQueue. You need FastArray instead");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new RuntimeException("Add is not supported by FastQueue. You need FastArray instead");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public void clear() {
        this.array.reset();
    }

    @Override
    public T get(int index) {
        return (T)this.array.data[index];
    }

    @Override
    public T set(int index, T element) {
        throw new RuntimeException("Set is not supported by FastQueue. You need FastArray instead");
    }

    @Override
    public void add(int index, T element) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public T remove(int index) {
        throw new RuntimeException("Not all list operations are supposed.");
    }

    @Override
    public int indexOf(Object o) {
        return this.array.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.array.size - 1; i >= 0; --i) {
            if (!this.array.data[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new MyIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new RuntimeException("Not supported");
    }

    public DogArray<T> getArray() {
        return this.array;
    }

    public void setArray(DogArray<T> array) {
        this.array = array;
    }

    public class MyIterator
    implements ListIterator<T> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < DogArrayList.this.array.size;
        }

        @Override
        public T next() {
            return DogArrayList.this.array.data[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            return DogArrayList.this.array.data[--this.index];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not all list operations are supposed.");
        }

        @Override
        public void set(T t) {
            DogArrayList.this.array.data[this.index - 1] = t;
        }

        @Override
        public void add(T t) {
            throw new RuntimeException("Add is not supported by FastQueue. Use FastArray instead");
        }
    }
}

