/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.List;

public class QuickSort_S32 {
    private int M = 7;
    private int NSTACK;
    private int[] istack;

    public QuickSort_S32() {
        this.NSTACK = 65;
        this.istack = new int[this.NSTACK];
    }

    public QuickSort_S32(int NSTACK, int M) {
        this.M = M;
        this.NSTACK = NSTACK;
        this.istack = new int[NSTACK];
    }

    public void sort(int[] arr, int length) {
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int i;
            int a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                    }
                    arr[i + 1] = a;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            int temp = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = temp;
            if (arr[l] > arr[ir]) {
                temp = arr[l];
                arr[l] = arr[ir];
                arr[ir] = temp;
            }
            if (arr[l + 1] > arr[ir]) {
                temp = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = temp;
            }
            if (arr[l] > arr[l + 1]) {
                temp = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                temp = arr[i];
                arr[i] = arr[j];
                arr[j] = temp;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    public void sort(int[] arr, int offset, int length, int[] indexes) {
        int i;
        for (i = 0; i < length; ++i) {
            indexes[i] = offset + i;
        }
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int temp;
            int a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[indexes[j]];
                    temp = indexes[j];
                    for (i = j - 1; i >= l && arr[indexes[i]] > a; --i) {
                        indexes[i + 1] = indexes[i];
                    }
                    indexes[i + 1] = temp;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            temp = indexes[k];
            indexes[k] = indexes[l + 1];
            indexes[l + 1] = temp;
            if (arr[indexes[l]] > arr[indexes[ir]]) {
                temp = indexes[l];
                indexes[l] = indexes[ir];
                indexes[ir] = temp;
            }
            if (arr[indexes[l + 1]] > arr[indexes[ir]]) {
                temp = indexes[l + 1];
                indexes[l + 1] = indexes[ir];
                indexes[ir] = temp;
            }
            if (arr[indexes[l]] > arr[indexes[l + 1]]) {
                temp = indexes[l];
                indexes[l] = indexes[l + 1];
                indexes[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[indexes[l + 1]];
            while (true) {
                if (arr[indexes[++i]] < a) {
                    continue;
                }
                while (arr[indexes[--j]] > a) {
                }
                if (j < i) break;
                temp = indexes[i];
                indexes[i] = indexes[j];
                indexes[j] = temp;
            }
            temp = indexes[l + 1];
            indexes[l + 1] = indexes[j];
            indexes[j] = temp;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    public <T> void sort(int[] arr, int length, List<T> list) {
        if (length != list.size()) {
            throw new IllegalArgumentException("length and the list's size must be the same");
        }
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int i;
            T la;
            int a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    la = list.get(j);
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        list.set(i + 1, list.get(i));
                        arr[i + 1] = arr[i];
                    }
                    arr[i + 1] = a;
                    list.set(i + 1, la);
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            QuickSort_S32.swap(k, l + 1, arr, list);
            if (arr[l] > arr[ir]) {
                QuickSort_S32.swap(l, ir, arr, list);
            }
            if (arr[l + 1] > arr[ir]) {
                QuickSort_S32.swap(l + 1, ir, arr, list);
            }
            if (arr[l] > arr[l + 1]) {
                QuickSort_S32.swap(l, l + 1, arr, list);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            la = list.get(l + 1);
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                QuickSort_S32.swap(i, j, arr, list);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            list.set(l + 1, list.get(j));
            list.set(j, la);
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    private static <T> void swap(int i, int j, int[] arr, List<T> list) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
        T tmp2 = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp2);
    }
}

