/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.lm;

import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.SchurJacobian;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.lm.LevenbergMarquardt_F64;
import org.ddogleg.optimization.math.HessianSchurComplement;
import org.ddogleg.optimization.math.MatrixMath;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;

public class UnconLeastSqLevenbergMarquardtSchur_F64<S extends DMatrix>
extends LevenbergMarquardt_F64<S, HessianSchurComplement<S>>
implements UnconstrainedLeastSquaresSchur<S> {
    public S jacLeft;
    public S jacRight;
    public FunctionNtoM functionResiduals;
    public SchurJacobian<S> functionJacobian;

    public UnconLeastSqLevenbergMarquardtSchur_F64(MatrixMath<S> math, HessianSchurComplement<S> hessian) {
        super(math, hessian);
        this.jacLeft = math.createMatrix();
        this.jacRight = math.createMatrix();
    }

    @Override
    public void setFunction(FunctionNtoM function, SchurJacobian<S> jacobian) {
        this.functionResiduals = function;
        this.functionJacobian = jacobian;
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        ((ConfigLevenbergMarquardt)this.config).ftol = ftol;
        ((ConfigLevenbergMarquardt)this.config).gtol = gtol;
        super.initialize(initial, this.functionResiduals.getNumOfInputsN(), this.functionResiduals.getNumOfOutputsM());
    }

    @Override
    public double[] getParameters() {
        return this.x.data;
    }

    @Override
    public double getFunctionValue() {
        return this.fx;
    }

    @Override
    public boolean isUpdated() {
        return this.mode == GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    @Override
    public boolean isConverged() {
        return this.mode == GaussNewtonBase_F64.Mode.CONVERGED;
    }

    @Override
    protected void functionGradientHessian(DMatrixRMaj x, boolean sameStateAsResiduals, DMatrixRMaj gradient, HessianSchurComplement<S> hessian) {
        if (!sameStateAsResiduals) {
            this.functionResiduals.process(x.data, this.residuals.data);
        }
        this.functionJacobian.process(x.data, this.jacLeft, this.jacRight);
        hessian.computeHessian(this.jacLeft, this.jacRight);
        hessian.computeGradient(this.jacLeft, this.jacRight, this.residuals, gradient);
    }

    @Override
    protected void computeResiduals(DMatrixRMaj x, DMatrixRMaj residuals) {
        this.functionResiduals.process(x.data, residuals.data);
    }
}

