/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.combinatorics;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Permute<T> {
    protected List<T> list;
    private int[] indexes;
    private int[] counters;
    private int total;
    private int permutation;

    public Permute(List<T> list) {
        this.init(list);
    }

    private void init(List<T> list) {
        int i;
        this.list = list;
        this.indexes = new int[list.size()];
        this.counters = new int[list.size()];
        for (i = 0; i < this.indexes.length; ++i) {
            this.counters[i] = this.indexes[i] = i;
        }
        this.total = 1;
        for (i = 2; i <= this.indexes.length; ++i) {
            this.total *= i;
        }
        this.permutation = 0;
    }

    public int getTotalPermutations() {
        return this.total;
    }

    public boolean next() {
        int N;
        int k;
        if (this.indexes.length <= 1 || this.permutation >= this.total - 1) {
            return false;
        }
        int n = k = (N = this.indexes.length - 2);
        int n2 = this.counters[n];
        this.counters[n] = n2 + 1;
        this.swap(k, n2);
        while (this.counters[k] == this.indexes.length) {
            int n3 = --k;
            int n4 = this.counters[n3];
            this.counters[n3] = n4 + 1;
            this.swap(k, n4);
        }
        this.swap(this.counters[k], k);
        while (k < this.indexes.length - 1) {
            this.counters[++k] = k;
        }
        ++this.permutation;
        return true;
    }

    public boolean previous() {
        int N;
        int k;
        if (this.indexes.length <= 1 || this.permutation <= 0) {
            return false;
        }
        for (k = N = this.indexes.length - 2; this.counters[k] <= k; --k) {
        }
        this.swap(this.counters[k], k);
        int n = k;
        this.counters[n] = this.counters[n] - 1;
        this.swap(k, this.counters[k]);
        int foo = k + 1;
        while (this.counters[k + 1] == k + 1 && k < this.indexes.length - 2) {
            this.swap(++k, this.indexes.length - 1);
        }
        for (int i = foo; i < this.indexes.length - 1; ++i) {
            this.counters[i] = this.indexes.length - 1;
        }
        --this.permutation;
        return true;
    }

    private void swap(int i, int j) {
        int val = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = val;
    }

    public int size() {
        return this.list.size();
    }

    public T get(int i) {
        return this.list.get(this.indexes[i]);
    }

    public List<T> getPermutation(@Nullable List<T> storage) {
        if (storage == null) {
            storage = new ArrayList<T>();
        } else {
            storage.clear();
        }
        for (int i = 0; i < this.list.size(); ++i) {
            storage.add(this.get(i));
        }
        return storage;
    }

    public static void main(String[] args) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            list.add(i);
        }
        Permute permute = new Permute(list);
        Permute.print(permute);
        while (permute.next()) {
            Permute.print(permute);
        }
        System.out.println();
        System.out.println("Reverse");
        Permute.print(permute);
        while (permute.previous()) {
            Permute.print(permute);
        }
    }

    private static void print(Permute permute) {
        System.out.print(" * ");
        for (int i = 0; i < permute.size(); ++i) {
            System.out.print(permute.get(i));
        }
        System.out.println();
    }
}

