/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.misc;

import java.util.Arrays;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

public class MeanArrayF64
implements ComputeMeanClusters<double[]> {
    final int length;
    DogArray_I32 counts = new DogArray_I32();

    public MeanArrayF64(int length) {
        this.length = length;
    }

    @Override
    public void process(LArrayAccessor<double[]> points, DogArray_I32 assignments, FastAccess<double[]> clusters) {
        int i;
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        this.counts.resetResize(clusters.size, 0);
        for (int i2 = 0; i2 < clusters.size; ++i2) {
            Arrays.fill(clusters.get(i2), 0, this.length, 0.0);
        }
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            int clusterIdx;
            double[] point = points.getTemp(pointIdx);
            int n = clusterIdx = assignments.get(pointIdx);
            this.counts.data[n] = this.counts.data[n] + 1;
            double[] cluster = clusters.get(clusterIdx);
            for (i = 0; i < this.length; ++i) {
                int n2 = i;
                cluster[n2] = cluster[n2] + point[i];
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            double[] cluster = clusters.get(clusterIdx);
            double divisor = this.counts.get(clusterIdx);
            i = 0;
            while (i < this.length) {
                int n = i++;
                cluster[n] = cluster[n] / divisor;
            }
        }
    }

    @Override
    public ComputeMeanClusters<double[]> newInstanceThread() {
        return new MeanArrayF64(this.length);
    }
}

