/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.clustering.gmm.GaussianLikelihoodManager;

public class AssignGmm_F64
implements AssignCluster<double[]> {
    protected List<GaussianGmm_F64> mixture;
    protected GaussianLikelihoodManager glm;

    public AssignGmm_F64(List<GaussianGmm_F64> mixture) {
        this.mixture = mixture;
        int N = mixture.get((int)0).mean.getNumElements();
        this.glm = new GaussianLikelihoodManager(N, mixture);
        this.glm.precomputeAll();
    }

    public AssignGmm_F64(AssignGmm_F64 original) {
        this.mixture = new ArrayList<GaussianGmm_F64>();
        for (int i = 0; i < original.mixture.size(); ++i) {
            GaussianGmm_F64 o = original.mixture.get(i);
            this.mixture.add(o.copy());
        }
        int N = this.mixture.get((int)0).mean.getNumElements();
        this.glm = new GaussianLikelihoodManager(N, this.mixture);
        this.glm.precomputeAll();
    }

    @Override
    public int assign(double[] point) {
        int indexBest = -1;
        double scoreBest = 0.0;
        for (int i = 0; i < this.mixture.size(); ++i) {
            double score = this.glm.getLikelihood(i).likelihood(point);
            if (!(score > scoreBest)) continue;
            scoreBest = score;
            indexBest = i;
        }
        return indexBest;
    }

    @Override
    public void assign(double[] point, double[] fit) {
        int i;
        double total = 0.0;
        for (i = 0; i < this.mixture.size(); ++i) {
            fit[i] = this.glm.getLikelihood(i).likelihood(point);
            total += fit[i];
        }
        i = 0;
        while (i < this.mixture.size()) {
            int n = i++;
            fit[n] = fit[n] / total;
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.mixture.size();
    }

    public List<GaussianGmm_F64> getMixture() {
        return this.mixture;
    }

    public void setMixture(List<GaussianGmm_F64> mixture) {
        this.mixture = mixture;
    }
}

