/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractFileTask(ZipModel zipModel, char[] password, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        try (ZipInputStream zipInputStream = this.createZipInputStream(taskParameters.fileHeader, taskParameters.zip4jConfig);){
            List<FileHeader> fileHeadersUnderDirectory = this.getFileHeadersToExtract(taskParameters.fileHeader);
            byte[] readBuff = new byte[taskParameters.zip4jConfig.getBufferSize()];
            for (FileHeader fileHeader : fileHeadersUnderDirectory) {
                String newFileName = this.determineNewFileName(taskParameters.newFileName, taskParameters.fileHeader, fileHeader);
                this.extractFile(zipInputStream, fileHeader, taskParameters.outputPath, newFileName, progressMonitor, readBuff);
            }
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters taskParameters) {
        List<FileHeader> fileHeadersUnderDirectory = this.getFileHeadersToExtract(taskParameters.fileHeader);
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(fileHeadersUnderDirectory);
    }

    private List<FileHeader> getFileHeadersToExtract(FileHeader rootFileHeader) {
        if (!rootFileHeader.isDirectory()) {
            return Collections.singletonList(rootFileHeader);
        }
        return HeaderUtil.getFileHeadersUnderDirectory(this.getZipModel().getCentralDirectory().getFileHeaders(), rootFileHeader);
    }

    private ZipInputStream createZipInputStream(FileHeader fileHeader, Zip4jConfig zip4jConfig) throws IOException {
        this.splitInputStream = UnzipUtil.createSplitInputStream(this.getZipModel());
        this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        return new ZipInputStream((InputStream)this.splitInputStream, this.password, zip4jConfig);
    }

    private String determineNewFileName(String newFileName, FileHeader fileHeaderToExtract, FileHeader fileHeaderBeingExtracted) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(newFileName)) {
            return newFileName;
        }
        if (!fileHeaderToExtract.isDirectory()) {
            return newFileName;
        }
        String fileSeparator = "/";
        if (newFileName.endsWith("/")) {
            fileSeparator = "";
        }
        return fileHeaderBeingExtracted.getFileName().replaceFirst(fileHeaderToExtract.getFileName(), newFileName + fileSeparator);
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private FileHeader fileHeader;
        private String newFileName;

        public ExtractFileTaskParameters(String outputPath, FileHeader fileHeader, String newFileName, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = outputPath;
            this.fileHeader = fileHeader;
            this.newFileName = newFileName;
        }
    }
}

