/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.table;

import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import mdlaf.components.table.MaterialTableCellEditor;
import mdlaf.components.table.MaterialTableCellRenderer;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTableUI
extends BasicTableUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.setOpaque(UIManager.getBoolean("Table.opaque"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setBackground(UIManager.getColor("Table.background"));
        this.table.setForeground(UIManager.getColor("Table.foreground"));
        this.table.setFont(UIManager.getFont("Table.font"));
        this.table.setBorder(UIManager.getBorder("Table.border"));
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setFocusable(UIManager.getBoolean("Table.focusable"));
        this.table.setRowHeight(UIManager.getInt("Table[row].height"));
        this.table.setShowHorizontalLines(UIManager.getBoolean("Table.showHorizontalLines"));
        this.table.setShowVerticalLines(UIManager.getBoolean("Table.showVerticalLines"));
        this.table.setShowGrid(UIManager.getBoolean("Table.showHorizontalLines") && UIManager.getBoolean("Table.showVerticalLines"));
        this.table.setRowHeight(UIManager.getInt("Table[row].height"));
        this.table.setIntercellSpacing(UIManager.getDimension("Table.intercellSpacing"));
        this.table.getTableHeader().setResizingAllowed(true);
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight > 0) {
            this.table.setRowHeight(rowHeight);
        } else {
            this.table.setRowHeight(this.table.getRowHeight() + 25);
        }
        this.setDefaultCellRenderWithType(this.table);
        this.table.setDefaultEditor(Object.class, new MaterialTableCellEditor());
        this.table.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.table.setSelectionForeground(null);
        this.table.setBackground(null);
        this.table.setForeground(null);
        this.table.setFont(null);
        this.table.setBorder(null);
        this.table.setSelectionBackground(null);
        this.table.removeEditor();
        this.table.setDefaultRenderer(Object.class, null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void setDefaultCellRenderWithType(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Table is null");
        }
        table.setDefaultRenderer(Object.class, new MaterialTableCellRenderer());
        table.setDefaultRenderer(String.class, new MaterialTableCellRenderer());
        table.setDefaultRenderer(Integer.class, new MaterialTableCellRenderer());
        table.setDefaultRenderer(Double.class, new MaterialTableCellRenderer());
        table.setDefaultRenderer(Float.class, new MaterialTableCellRenderer());
        table.setDefaultRenderer(Boolean.class, new MaterialTableCellRenderer());
    }
}

