/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.twist;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.misc.GrlConstants;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.twist.TwistCoordinate_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.jetbrains.annotations.Nullable;

public class TwistOps_F64 {
    public static DMatrixRMaj homogenous(Se3_F64 transform, @Nullable DMatrixRMaj H) {
        if (H == null) {
            H = new DMatrixRMaj(4, 4);
        } else {
            H.reshape(4, 4);
        }
        CommonOps_DDRM.insert(transform.R, H, 0, 0);
        H.data[3] = transform.T.x;
        H.data[7] = transform.T.y;
        H.data[11] = transform.T.z;
        H.data[12] = 0.0;
        H.data[13] = 0.0;
        H.data[14] = 0.0;
        H.data[15] = 1.0;
        return H;
    }

    public static DMatrixRMaj homogenous(TwistCoordinate_F64 twist, @Nullable DMatrixRMaj H) {
        if (H == null) {
            H = new DMatrixRMaj(4, 4);
        } else {
            H.reshape(4, 4);
            H.data[12] = 0.0;
            H.data[13] = 0.0;
            H.data[14] = 0.0;
            H.data[15] = 0.0;
        }
        H.data[0] = 0.0;
        H.data[1] = -twist.w.z;
        H.data[2] = twist.w.y;
        H.data[3] = twist.v.x;
        H.data[4] = twist.w.z;
        H.data[5] = 0.0;
        H.data[6] = -twist.w.x;
        H.data[7] = twist.v.y;
        H.data[8] = -twist.w.y;
        H.data[9] = twist.w.x;
        H.data[10] = 0.0;
        H.data[11] = twist.v.z;
        return H;
    }

    public static Se3_F64 exponential(TwistCoordinate_F64 twist, double theta, @Nullable Se3_F64 motion) {
        double w_norm;
        if (motion == null) {
            motion = new Se3_F64();
        }
        if ((w_norm = twist.w.norm()) == 0.0) {
            CommonOps_DDRM.setIdentity(motion.R);
            motion.T.x = twist.v.x * theta;
            motion.T.y = twist.v.y * theta;
            motion.T.z = twist.v.z * theta;
            return motion;
        }
        DMatrixRMaj R = motion.getR();
        double wx = twist.w.x / w_norm;
        double wy = twist.w.y / w_norm;
        double wz = twist.w.z / w_norm;
        ConvertRotation3D_F64.rodriguesToMatrix(wx, wy, wz, theta * w_norm, R);
        theta *= w_norm;
        double vx = twist.v.x;
        double vy = twist.v.y;
        double vz = twist.v.z;
        double wv_x = wy * vz - wz * vy;
        double wv_y = wz * vx - wx * vz;
        double wv_z = wx * vy - wy * vx;
        double left_x = (1.0 - R.data[0]) * wv_x - R.data[1] * wv_y - R.data[2] * wv_z;
        double left_y = -R.data[3] * wv_x + (1.0 - R.data[4]) * wv_y - R.data[5] * wv_z;
        double left_z = -R.data[6] * wv_x - R.data[7] * wv_y + (1.0 - R.data[8]) * wv_z;
        double right_x = (wx * wx * vx + wx * wy * vy + wx * wz * vz) * theta;
        double right_y = (wy * wx * vx + wy * wy * vy + wy * wz * vz) * theta;
        double right_z = (wz * wx * vx + wz * wy * vy + wz * wz * vz) * theta;
        motion.T.x = left_x + right_x;
        motion.T.y = left_y + right_y;
        motion.T.z = left_z + right_z;
        motion.T.divide(w_norm);
        return motion;
    }

    public static TwistCoordinate_F64 twist(Se3_F64 motion, @Nullable TwistCoordinate_F64 twist) {
        if (twist == null) {
            twist = new TwistCoordinate_F64();
        }
        if (MatrixFeatures_DDRM.isIdentity(motion.R, GrlConstants.TEST_F64)) {
            twist.w.setTo(0.0, 0.0, 0.0);
            twist.v.setTo(motion.T);
        } else {
            Rodrigues_F64 rod = new Rodrigues_F64();
            ConvertRotation3D_F64.matrixToRodrigues(motion.R, rod);
            twist.w.setTo(rod.unitAxisRotation);
            double theta = rod.theta;
            DMatrixRMaj A2 = CommonOps_DDRM.identity(3);
            CommonOps_DDRM.subtract(A2, motion.R, A2);
            DMatrixRMaj w_hat = GeometryMath_F64.crossMatrix(twist.w, null);
            DMatrixRMaj tmp = A2.copy();
            CommonOps_DDRM.mult(tmp, w_hat, A2);
            Vector3D_F64 w = twist.w;
            A2.data[0] = A2.data[0] + w.x * w.x * theta;
            A2.data[1] = A2.data[1] + w.x * w.y * theta;
            A2.data[2] = A2.data[2] + w.x * w.z * theta;
            A2.data[3] = A2.data[3] + w.y * w.x * theta;
            A2.data[4] = A2.data[4] + w.y * w.y * theta;
            A2.data[5] = A2.data[5] + w.y * w.z * theta;
            A2.data[6] = A2.data[6] + w.z * w.x * theta;
            A2.data[7] = A2.data[7] + w.z * w.y * theta;
            A2.data[8] = A2.data[8] + w.z * w.z * theta;
            DMatrixRMaj y = new DMatrixRMaj(3, 1);
            y.data[0] = motion.T.x;
            y.data[1] = motion.T.y;
            y.data[2] = motion.T.z;
            DMatrixRMaj x = new DMatrixRMaj(3, 1);
            CommonOps_DDRM.solve(A2, y, x);
            twist.w.scale(rod.theta);
            twist.v.x = x.data[0];
            twist.v.y = x.data[1];
            twist.v.z = x.data[2];
            twist.v.scale(rod.theta);
        }
        return twist;
    }
}

