/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.RotationType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.SpecialEuclidean;
import georegression.struct.so.Quaternion_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.text.DecimalFormat;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class Se3_F64
implements SpecialEuclidean<Se3_F64> {
    public static final long serialVersionUID = 1L;
    public DMatrixRMaj R;
    public Vector3D_F64 T;

    public Se3_F64() {
        this.R = CommonOps_DDRM.identity(3);
        this.T = new Vector3D_F64();
    }

    public Se3_F64(DMatrixRMaj R, Vector3D_F64 T) {
        this(R, T, false);
    }

    public Se3_F64(DMatrixRMaj R, Vector3D_F64 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void setTo(Se3_F64 se) {
        this.R.setTo(se.getR());
        this.T.setTo(se.getT());
    }

    public void setRotation(DMatrixRMaj R) {
        this.R.setTo(R);
    }

    public void setTranslation(Vector3D_F64 T) {
        this.T.setTo(T);
    }

    public void setTranslation(double x, double y, double z) {
        this.T.setTo(x, y, z);
    }

    public DMatrixRMaj getRotation() {
        return this.R;
    }

    public Vector3D_F64 getTranslation() {
        return this.T;
    }

    public DMatrixRMaj getR() {
        return this.R;
    }

    public Vector3D_F64 getT() {
        return this.T;
    }

    public double getX() {
        return this.T.getX();
    }

    public double getY() {
        return this.T.getY();
    }

    public double getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F64 createInstance() {
        return new Se3_F64();
    }

    @Override
    public Se3_F64 concat(Se3_F64 second, @Nullable Se3_F64 result) {
        if (result == null) {
            result = new Se3_F64();
        }
        CommonOps_DDRM.mult(second.getR(), this.getR(), result.getR());
        GeometryMath_F64.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F64.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F64 invert(@Nullable Se3_F64 inverse) {
        if (inverse == null) {
            inverse = new Se3_F64();
        }
        GeometryMath_F64.multTran(this.R, this.T, inverse.T);
        GeometryMath_F64.changeSign(inverse.T);
        CommonOps_DDRM.transpose(this.R, inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps_DDRM.setIdentity(this.R);
        this.T.setTo(0.0, 0.0, 0.0);
    }

    public void setTo(double x, double y, double z, EulerType type, double rotA, double rotB, double rotC) {
        this.T.setTo(x, y, z);
        ConvertRotation3D_F64.eulerToMatrix(type, rotA, rotB, rotC, this.R);
    }

    public void setTo(double x, double y, double z, RotationType type, double A2, double B, double C, double D2) {
        this.T.setTo(x, y, z);
        switch (type) {
            case RODRIGUES: {
                ConvertRotation3D_F64.rodriguesToMatrix(A2, B, C, D2, this.R);
                break;
            }
            case QUATERNION: {
                ConvertRotation3D_F64.quaternionToMatrix(A2, B, C, D2, this.R);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type is not supported. " + (Object)((Object)type));
            }
        }
    }

    public Point3D_F64 transform(Point3D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transform(this, src, dst);
    }

    public Point3D_F64 transformReverse(Point3D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transformReverse(this, src, dst);
    }

    public Vector3D_F64 transform(Vector3D_F64 src, @Nullable Vector3D_F64 dst) {
        return GeometryMath_F64.mult(this.R, src, dst);
    }

    public Vector3D_F64 transformReverse(Vector3D_F64 src, @Nullable Vector3D_F64 dst) {
        return GeometryMath_F64.multTran(this.R, src, dst);
    }

    public Se3_F64 copy() {
        Se3_F64 ret = new Se3_F64();
        ret.setTo(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F64: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret;
    }

    public String toString(RotationType type) {
        DecimalFormat format = new DecimalFormat("#");
        int sig = 4;
        String tx = UtilEjml.fancyString(this.T.x, format, false, 11, 4);
        String ty = UtilEjml.fancyString(this.T.y, format, false, 11, 4);
        String tz = UtilEjml.fancyString(this.T.z, format, false, 11, 4);
        String ret = "Se3_F64: T=(" + tx + ", " + ty + ", " + tz + "), ";
        switch (type) {
            case EULER: {
                double[] euler = new double[3];
                ConvertRotation3D_F64.matrixToEuler(this.R, EulerType.XYZ, euler);
                ret = ret + "EulerXYZ=(" + UtilEjml.fancyString(euler[0], format, false, 11, 4) + ", " + UtilEjml.fancyString(euler[1], format, false, 11, 4) + ", " + UtilEjml.fancyString(euler[2], format, false, 11, 4) + ")";
                break;
            }
            case RODRIGUES: {
                Rodrigues_F64 rod = ConvertRotation3D_F64.matrixToRodrigues(this.R, null);
                ret = ret + "Rodrigues={n=(" + UtilEjml.fancyString(rod.unitAxisRotation.x, format, false, 11, 4) + ", " + UtilEjml.fancyString(rod.unitAxisRotation.y, format, false, 11, 4) + ", " + UtilEjml.fancyString(rod.unitAxisRotation.z, format, false, 11, 4) + "), theta=" + UtilEjml.fancyString(rod.theta, format, false, 11, 4) + "}";
                break;
            }
            case QUATERNION: {
                Quaternion_F64 quat = ConvertRotation3D_F64.matrixToQuaternion(this.R, null);
                ret = ret + "Quaternion=(" + UtilEjml.fancyString(quat.x, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.y, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.z, format, false, 11, 4) + ", " + UtilEjml.fancyString(quat.w, format, false, 11, 4) + ")";
            }
        }
        return ret;
    }

    public void print() {
        System.out.println(this);
    }

    public void print(RotationType type) {
        System.out.println(this.toString(type));
    }
}

