/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point2D_F64;
import java.io.Serializable;

public class LineSegment2D_F64
implements Serializable {
    public Point2D_F64 a = new Point2D_F64();
    public Point2D_F64 b = new Point2D_F64();

    public LineSegment2D_F64() {
    }

    public LineSegment2D_F64(Point2D_F64 a, Point2D_F64 b) {
        this.setTo(a, b);
    }

    public LineSegment2D_F64(double x0, double y0, double x1, double y1) {
        this.setTo(x0, y0, x1, y1);
    }

    public static LineSegment2D_F64 wrap(Point2D_F64 a, Point2D_F64 b) {
        LineSegment2D_F64 ret = new LineSegment2D_F64();
        ret.a = a;
        ret.b = b;
        return ret;
    }

    public void setTo(LineSegment2D_F64 l) {
        this.a.setTo(l.a);
        this.b.setTo(l.b);
    }

    public void setTo(Point2D_F64 a, Point2D_F64 b) {
        this.a.setTo(a);
        this.b.setTo(b);
    }

    public void setTo(double x0, double y0, double x1, double y1) {
        this.a.setTo(x0, y0);
        this.b.setTo(x1, y1);
    }

    public Point2D_F64 getA() {
        return this.a;
    }

    public void setA(Point2D_F64 a) {
        this.a = a;
    }

    public Point2D_F64 getB() {
        return this.b;
    }

    public void setB(Point2D_F64 b) {
        this.b = b;
    }

    public double slopeX() {
        return this.b.x - this.a.x;
    }

    public double slopeY() {
        return this.b.y - this.a.y;
    }

    public double getLength() {
        return this.a.distance(this.b);
    }

    public double getLength2() {
        return this.a.distance2(this.b);
    }

    public LineSegment2D_F64 copy() {
        return new LineSegment2D_F64(this.a, this.b);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{a=" + this.a + ", b=" + this.b + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment2D_F64)) {
            return false;
        }
        LineSegment2D_F64 o = (LineSegment2D_F64)obj;
        return this.a.equals(o.a) && this.b.equals(o.b);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }
}

