/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import org.ejml.UtilEjml;

public class ParabolaGeneral_F64 {
    public double A;
    public double C;
    public double D;
    public double E;
    public double F;

    public ParabolaGeneral_F64(double a, double c, double d, double e, double f) {
        this.A = a;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public ParabolaGeneral_F64(ParabolaGeneral_F64 original) {
        this.setTo(original);
    }

    public ParabolaGeneral_F64() {
    }

    public void setTo(ParabolaGeneral_F64 original) {
        this.A = original.A;
        this.C = original.C;
        this.D = original.D;
        this.E = original.E;
        this.F = original.F;
    }

    public void setTo(double a, double c, double d, double e, double f) {
        this.A = a;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public double evaluate(double x, double y) {
        double inner = this.A * x + this.C * y;
        return inner * inner + this.D * x + this.E * y + this.F;
    }

    public void toArray(double[] array) {
        array[0] = this.A;
        array[1] = this.C;
        array[2] = this.D;
        array[3] = this.E;
        array[4] = this.F;
    }

    public void fromArray(double[] array) {
        this.A = array[0];
        this.C = array[1];
        this.D = array[2];
        this.E = array[3];
        this.F = array[4];
    }

    public boolean hasUncountable() {
        return UtilEjml.isUncountable(this.A) || UtilEjml.isUncountable(this.C) || UtilEjml.isUncountable(this.D) || UtilEjml.isUncountable(this.E) || UtilEjml.isUncountable(this.F);
    }

    public double relativeScale(ParabolaGeneral_F64 parabola) {
        double scale = this.A / parabola.A;
        double max = Math.abs(parabola.A);
        if (max < Math.abs(parabola.C)) {
            max = Math.abs(parabola.C);
            scale = this.C / parabola.C;
        }
        if (max < Math.abs(parabola.D)) {
            max = Math.abs(parabola.D);
            scale = this.D / parabola.D;
        }
        if (max < Math.abs(parabola.E)) {
            max = Math.abs(parabola.E);
            scale = this.E / parabola.E;
        }
        if (max < Math.abs(parabola.F)) {
            max = Math.abs(parabola.F);
            scale = this.F / parabola.F;
        }
        if (max == 0.0) {
            scale = 0.0;
        }
        return scale;
    }

    public boolean isEquivalent(ParabolaGeneral_F64 parabola, double tol) {
        double scale = this.relativeScale(parabola);
        if (Math.abs(this.A * scale - parabola.A) > tol) {
            return false;
        }
        if (Math.abs(this.C * scale - parabola.C) > tol) {
            return false;
        }
        if (Math.abs(this.D * scale - parabola.D) > tol) {
            return false;
        }
        if (Math.abs(this.E * scale - parabola.E) > tol) {
            return false;
        }
        return !(Math.abs(this.F * scale - parabola.F) > tol);
    }
}

