/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.points;

import georegression.fitting.MotionTransformPoint;
import georegression.fitting.points.ClosestPointToModel;
import georegression.fitting.points.IterativeClosestPoint;
import georegression.fitting.points.MatchCloudToCloud;
import georegression.misc.StoppingCondition;
import georegression.struct.GeoTuple;
import georegression.struct.InvertibleTransform;
import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.jetbrains.annotations.Nullable;

public abstract class MatchCloudToCloudIcp<SE extends InvertibleTransform, P extends GeoTuple>
implements MatchCloudToCloud<SE, P> {
    NearestNeighbor<P> nn;
    NearestNeighbor.Search<P> searchNN;
    IterativeClosestPoint.Distance<P> distance;
    List<P> source;
    double maxDistanceSq;
    NnData<P> storageNN = new NnData();
    IterativeClosestPoint<SE, P> icp;

    protected MatchCloudToCloudIcp(MotionTransformPoint<SE, P> motion, NearestNeighbor<P> nn, IterativeClosestPoint.Distance<P> distance, double maxDistanceSq, StoppingCondition stop) {
        this.maxDistanceSq = maxDistanceSq;
        this.nn = nn;
        this.distance = distance;
        this.icp = new IterativeClosestPoint<SE, P>(stop, motion, distance);
        this.icp.setModel(new Model());
        this.searchNN = nn.createSearch();
    }

    @Override
    public void setSource(List<P> source) {
        this.source = source;
    }

    @Override
    public void setDestination(List<P> destination) {
        this.nn.setPoints(destination, false);
    }

    @Override
    public boolean compute() {
        return this.icp.process(this.source);
    }

    @Override
    public SE getSourceToDestination() {
        return this.icp.getPointsToModel();
    }

    @Override
    public boolean isModifiedSource() {
        return true;
    }

    @Override
    public int getMatchedSourcePoints() {
        return this.icp.getTotalMatched();
    }

    public IterativeClosestPoint<SE, P> getIcp() {
        return this.icp;
    }

    private class Model
    implements ClosestPointToModel<P> {
        private Model() {
        }

        @Override
        @Nullable
        public P findClosestPoint(P target) {
            if (MatchCloudToCloudIcp.this.searchNN.findNearest(target, MatchCloudToCloudIcp.this.maxDistanceSq, MatchCloudToCloudIcp.this.storageNN)) {
                return (GeoTuple)MatchCloudToCloudIcp.this.storageNN.point;
            }
            return null;
        }
    }
}

