/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.struct.curve.EllipseQuadratic_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.jetbrains.annotations.Nullable;

public class FitEllipseWeightedAlgebraic_F64 {
    private DMatrixRMaj D1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj D2 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj S1 = new DMatrixRMaj(3, 3);
    private DMatrixRMaj S2 = new DMatrixRMaj(3, 3);
    private DMatrixRMaj S3 = new DMatrixRMaj(3, 3);
    private DMatrixRMaj M = new DMatrixRMaj(3, 3);
    private DMatrixRMaj T = new DMatrixRMaj(3, 3);
    private DMatrixRMaj Ta1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj S2_tran = new DMatrixRMaj(3, 3);
    private LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear(3);
    private EigenDecomposition<DMatrixRMaj> eigen = DecompositionFactory_DDRM.eig(3, true, false);
    private EllipseQuadratic_F64 ellipse = new EllipseQuadratic_F64();

    public boolean process(List<Point2D_F64> points, double[] weights) {
        if (points.size() > weights.length) {
            throw new IllegalArgumentException("Weights must be as long as the number of points. " + points.size() + " vs " + weights.length);
        }
        int N = points.size();
        this.D1.reshape(N, 3);
        this.D2.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            double w = weights[i];
            this.D1.data[index] = w * p.x * p.x;
            this.D2.data[index++] = w * p.x;
            this.D1.data[index] = w * p.x * p.y;
            this.D2.data[index++] = w * p.y;
            this.D1.data[index] = w * p.y * p.y;
            this.D2.data[index++] = w;
        }
        CommonOps_DDRM.multTransA(this.D1, this.D1, this.S1);
        CommonOps_DDRM.multTransA(this.D1, this.D2, this.S2);
        CommonOps_DDRM.multTransA(this.D2, this.D2, this.S3);
        if (!this.solver.setA(this.S3)) {
            return false;
        }
        CommonOps_DDRM.transpose(this.S2, this.S2_tran);
        CommonOps_DDRM.changeSign(this.S2_tran);
        this.solver.solve(this.S2_tran, this.T);
        CommonOps_DDRM.mult(this.S2, this.T, this.M);
        CommonOps_DDRM.add(this.M, this.S1, this.M);
        for (int col = 0; col < 3; ++col) {
            double m0 = this.M.unsafe_get(0, col);
            double m1 = this.M.unsafe_get(1, col);
            double m2 = this.M.unsafe_get(2, col);
            this.M.unsafe_set(0, col, m2 / 2.0);
            this.M.unsafe_set(1, col, -m1);
            this.M.unsafe_set(2, col, m0 / 2.0);
        }
        if (!this.eigen.decompose(this.M)) {
            return false;
        }
        DMatrixRMaj a1 = this.selectBestEigenVector();
        if (a1 == null) {
            return false;
        }
        CommonOps_DDRM.mult(this.T, a1, this.Ta1);
        this.ellipse.A = a1.data[0];
        this.ellipse.B = a1.data[1] / 2.0;
        this.ellipse.C = a1.data[2];
        this.ellipse.D = this.Ta1.data[0] / 2.0;
        this.ellipse.E = this.Ta1.data[1] / 2.0;
        this.ellipse.F = this.Ta1.data[2];
        return true;
    }

    @Nullable
    private DMatrixRMaj selectBestEigenVector() {
        int bestIndex = -1;
        double bestCond = Double.MAX_VALUE;
        for (int i = 0; i < this.eigen.getNumberOfEigenvalues(); ++i) {
            DMatrixRMaj v = this.eigen.getEigenVector(i);
            if (v == null) continue;
            double cond = 4.0 * v.get(0) * v.get(2) - v.get(1) * v.get(1);
            double condError = (cond - 1.0) * (cond - 1.0);
            if (!(cond > 0.0) || !(condError < bestCond)) continue;
            bestCond = condError;
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return this.eigen.getEigenVector(bestIndex);
    }

    public EllipseQuadratic_F64 getEllipse() {
        return this.ellipse;
    }
}

