/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.io.torch7.SerializeTorch7;
import deepboof.io.torch7.TorchType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerializeBinaryTorch7
extends SerializeTorch7 {
    boolean littleEndian = true;

    public SerializeBinaryTorch7(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    @Override
    public void writeShape(int[] shape) throws IOException {
        for (int i = 0; i < shape.length; ++i) {
            this.writeS64(shape[i]);
        }
    }

    @Override
    public void writeType(TorchType type) throws IOException {
        this.writeS32(type.value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.writeS32(1);
        } else {
            this.writeS32(0);
        }
    }

    @Override
    public void writeDouble(double value) throws IOException {
        long a = Double.doubleToLongBits(value);
        if (this.littleEndian) {
            a = Long.reverseBytes(a);
        }
        this.output.writeLong(a);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        int a = Float.floatToIntBits(value);
        if (this.littleEndian) {
            a = Integer.reverseBytes(a);
        }
        this.output.writeFloat(Float.intBitsToFloat(a));
    }

    @Override
    public void writeString(String value) throws IOException {
        this.writeS32(value.length());
        for (int i = 0; i < value.length(); ++i) {
            byte b = (byte)value.charAt(i);
            this.writeU8(b);
        }
    }

    @Override
    public void writeS64(long value) throws IOException {
        if (this.littleEndian) {
            this.output.writeLong(Long.reverseBytes(value));
        } else {
            this.output.writeLong(value);
        }
    }

    @Override
    public void writeS32(int value) throws IOException {
        if (this.littleEndian) {
            this.output.writeInt(Integer.reverseBytes(value));
        } else {
            this.output.writeInt(value);
        }
    }

    @Override
    public void writeU8(int value) throws IOException {
        this.output.writeByte(value);
    }

    @Override
    public void writeArrayDouble(double[] storage, int size) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(size * 8);
        DataOutputStream encode = new DataOutputStream(stream);
        for (int i = 0; i < size; ++i) {
            long a = Double.doubleToLongBits(storage[i]);
            if (this.littleEndian) {
                encode.writeLong(Long.reverseBytes(a));
                continue;
            }
            encode.writeLong(a);
        }
        this.output.write(stream.toByteArray());
    }

    @Override
    public void writeArrayFloat(float[] storage, int size) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(size * 4);
        DataOutputStream encode = new DataOutputStream(stream);
        for (int i = 0; i < size; ++i) {
            int a = Float.floatToIntBits(storage[i]);
            if (this.littleEndian) {
                encode.writeInt(Integer.reverseBytes(a));
                continue;
            }
            encode.writeInt(a);
        }
        this.output.write(stream.toByteArray());
    }

    @Override
    public void writeArrayChar(char[] storage, int size) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(size * 2);
        DataOutputStream encode = new DataOutputStream(stream);
        for (int i = 0; i < size; ++i) {
            if (this.littleEndian) {
                encode.writeShort(Short.reverseBytes((short)storage[i]));
                continue;
            }
            encode.writeShort(storage[i]);
        }
        this.output.write(stream.toByteArray());
    }

    @Override
    public void writeArrayByte(byte[] storage, int size) throws IOException {
        this.output.write(storage, 0, size);
    }
}

