/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;

public final class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static GraphicsContext setupAntialiasing(Graphics g2) {
        return GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static GraphicsContext setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        GraphicsContext config = new GraphicsContext(g2);
        if (g2 instanceof Graphics2D) {
            Graphics2D g = (Graphics2D)g2;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null && !ignoreSystemSettings) {
                g.addRenderingHints(map);
            } else {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, enableAA ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
        return config;
    }

    public static GraphicsContext setupAAPainting(Graphics g) {
        GraphicsContext config = new GraphicsContext(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return config;
    }

    public static GraphicsContext paintWithAlpha(Graphics g, float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsContext config = new GraphicsContext(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        return config;
    }

    public static GraphicsContext setupStrokePainting(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsContext context = new GraphicsContext(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, DarkUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        return context;
    }

    public static boolean isHighDpiEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("hidpi"));
    }
}

