/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class DropPreviewPanel
extends JComponent {
    private JToolBar toolBar;
    private Color dropBackground = UIManager.getColor("ToolBar.dropColor");

    public void setToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected Color getBackgroundColor() {
        boolean useToolbar = Boolean.TRUE.equals(this.toolBar.getClientProperty("JToolBar.drag.useToolbarBackground"));
        if (!useToolbar) {
            Color c = this.dropBackground;
            if (c == null) {
                return this.toolBar.getBackground();
            }
            return c;
        }
        return this.toolBar.getBackground();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.toolBar != null) {
            return this.toolBar.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.toolBar != null) {
            return this.toolBar.getMaximumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.toolBar != null) {
            return this.toolBar.getMinimumSize();
        }
        return super.getMinimumSize();
    }
}

