/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyActionMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToolBarUI;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public abstract class DarkToolBarUIBridge
extends ToolBarUI
implements SwingConstants {
    protected static String IS_ROLLOVER = "JToolBar.isRollover";
    protected static Border rolloverBorder;
    protected static Border nonRolloverBorder;
    protected static Border nonRolloverToggleBorder;
    protected static String FOCUSED_COMP_INDEX;
    protected JToolBar toolBar;
    protected boolean floating;
    protected int floatingX;
    protected int floatingY;
    protected RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    protected Container dockingSource;
    protected int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected Handler handler;
    protected String constraintBeforeFloating = "North";
    protected boolean rolloverBorders = false;
    protected HashMap<AbstractButton, Border> borderTable = new HashMap();
    protected Hashtable<AbstractButton, Boolean> rolloverTable = new Hashtable();
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("navigateRight"));
        map.put(new Actions("navigateLeft"));
        map.put(new Actions("navigateUp"));
        map.put(new Actions("navigateDown"));
    }

    @Override
    public void installUI(JComponent c) {
        this.toolBar = (JToolBar)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        LookAndFeel.installProperty(c, "opaque", Boolean.TRUE);
        if (c.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)c.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        c.putClientProperty(FOCUSED_COMP_INDEX, this.focusedCompIndex);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void uninstallComponents() {
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] components;
            for (Component component : components = this.toolBar.getComponents()) {
                component.removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    public boolean isFloating() {
        return this.floating;
    }

    public abstract void setFloating(boolean var1, Point var2);

    protected void installNormalBorders(JComponent c) {
        Component[] components;
        for (Component component : components = c.getComponents()) {
            this.setBorderToNormal(component);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = this.borderTable.remove(b);
            b.setBorder(border);
            Boolean value = this.rolloverTable.remove(b);
            if (value != null) {
                b.setRolloverEnabled(value);
            }
        }
    }

    protected void installDefaults() {
        Object rolloverProp;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((rolloverProp = this.toolBar.getClientProperty(IS_ROLLOVER)) == null) {
            rolloverProp = UIManager.get("ToolBar.isRollover");
        }
        if (rolloverProp != null) {
            this.rolloverBorders = (Boolean)rolloverProp;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void installComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] components;
            for (Component component : components = this.toolBar.getComponents()) {
                component.addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, km);
        LazyActionMap.installLazyActionMap(this.toolBar, BasicToolBarUI.class, "ToolBar.actionMap");
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    protected Border createRolloverBorder() {
        Object border = UIManager.get("ToolBar.rolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RolloverButtonBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight")), new EmptyBorder(0, 0, 0, 0));
    }

    protected Border createNonRolloverBorder() {
        Object border = UIManager.get("ToolBar.nonrolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.darkShadow"), table.getColor("Button.light"), table.getColor("Button.highlight")), new EmptyBorder(0, 0, 0, 0));
    }

    protected Border createNonRolloverToggleBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RadioButtonBorder(table.getColor("ToggleButton.shadow"), table.getColor("ToggleButton.darkShadow"), table.getColor("ToggleButton.light"), table.getColor("ToggleButton.highlight")), new EmptyBorder(0, 0, 0, 0));
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean rollover) {
        this.rolloverBorders = rollover;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.toolBar, this, "ToolBar.ancestorInputMap");
        }
        return null;
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components;
        for (Component component : components = c.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
            this.setBorderToRollover(component);
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components;
        for (Component component : components = c.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
            this.setBorderToNonRollover(component);
        }
    }

    protected Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(this.getRolloverBorder(b));
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(this.getNonRolloverBorder(b));
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(false);
        }
    }

    protected Border getRolloverBorder(AbstractButton b) {
        return rolloverBorder;
    }

    protected Border getNonRolloverBorder(AbstractButton b) {
        if (b instanceof JToggleButton) {
            return nonRolloverToggleBorder;
        }
        return nonRolloverBorder;
    }

    protected void navigateFocusedComp(int direction) {
        int nComp = this.toolBar.getComponentCount();
        block0 : switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex + 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j >= nComp) {
                        j = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j++)) == null || !comp.isFocusTraversable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex - 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j < 0) {
                        j = nComp - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j--)) == null || !comp.isFocusTraversable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    protected boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected abstract DragWindow createDragWindow(JToolBar var1);

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    protected int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    protected abstract boolean isBlocked(Component var1, Object var2);

    public boolean canDock(Component c, Point p) {
        return p != null && this.getDockingConstraint(c, p) != null;
    }

    protected abstract String getDockingConstraint(Component var1, Point var2);

    protected String calculateConstraint() {
        String constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BorderLayout) {
            constraint = (String)((BorderLayout)lm).getConstraints(this.toolBar);
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    protected abstract void dragTo();

    protected abstract void floatAt();

    protected void paintDragWindow(Graphics g) {
        g.setColor(this.dragWindow.getBackground());
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        g.fillRect(0, 0, w, h);
        g.setColor(this.dragWindow.getBorderColor());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    protected static class Actions
    extends UIAction {
        protected static final String NAVIGATE_RIGHT = "navigateRight";
        protected static final String NAVIGATE_LEFT = "navigateLeft";
        protected static final String NAVIGATE_UP = "navigateUp";
        protected static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String key = this.getName();
            JToolBar toolBar = (JToolBar)evt.getSource();
            DarkToolBarUIBridge ui = (DarkToolBarUIBridge)DarkUIUtil.getUIOfType(toolBar.getUI(), DarkToolBarUIBridge.class);
            if (ui == null) {
                return;
            }
            if (Objects.equals(NAVIGATE_RIGHT, key)) {
                ui.navigateFocusedComp(3);
            } else if (Objects.equals(NAVIGATE_LEFT, key)) {
                ui.navigateFocusedComp(7);
            } else if (Objects.equals(NAVIGATE_UP, key)) {
                ui.navigateFocusedComp(1);
            } else if (Objects.equals(NAVIGATE_DOWN, key)) {
                ui.navigateFocusedComp(5);
            }
        }
    }

    protected class DragWindow
    extends JWindow {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window w) {
            super(w);
            this.borderColor = Color.gray;
            this.orientation = DarkToolBarUIBridge.this.toolBar.getOrientation();
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                this.setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (DarkToolBarUIBridge.this.toolBar.getComponentOrientation().isLeftToRight()) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Color c) {
            if (this.borderColor == c) {
                return;
            }
            this.borderColor = c;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            DarkToolBarUIBridge.this.paintDragWindow(g);
            super.paint(g);
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    protected class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;

        protected Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (DarkToolBarUIBridge.this.toolBarFocusListener != null) {
                c.addFocusListener(DarkToolBarUIBridge.this.toolBarFocusListener);
            }
            if (DarkToolBarUIBridge.this.isRolloverBorders()) {
                DarkToolBarUIBridge.this.setBorderToRollover(c);
            } else {
                DarkToolBarUIBridge.this.setBorderToNonRollover(c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (DarkToolBarUIBridge.this.toolBarFocusListener != null) {
                c.removeFocusListener(DarkToolBarUIBridge.this.toolBarFocusListener);
            }
            DarkToolBarUIBridge.this.setBorderToNormal(c);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component c = evt.getComponent();
            DarkToolBarUIBridge.this.focusedCompIndex = DarkToolBarUIBridge.this.toolBar.getComponentIndex(c);
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = true;
            DarkToolBarUIBridge.this.dragTo();
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                DarkToolBarUIBridge.this.floatAt();
            }
            this.isDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (Objects.equals(propertyName, "lookAndFeel")) {
                DarkToolBarUIBridge.this.toolBar.updateUI();
            } else if (Objects.equals(propertyName, "orientation")) {
                Component[] components = DarkToolBarUIBridge.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (Component component : components) {
                    if (!(component instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)component;
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            } else if (Objects.equals(propertyName, IS_ROLLOVER)) {
                DarkToolBarUIBridge.this.installNormalBorders(DarkToolBarUIBridge.this.toolBar);
                DarkToolBarUIBridge.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (DarkToolBarUIBridge.this.toolBar.isFloatable()) {
                if (DarkToolBarUIBridge.this.dragWindow != null) {
                    DarkToolBarUIBridge.this.dragWindow.setVisible(false);
                }
                DarkToolBarUIBridge.this.floating = false;
                if (DarkToolBarUIBridge.this.floatingToolBar == null) {
                    DarkToolBarUIBridge.this.floatingToolBar = DarkToolBarUIBridge.this.createFloatingWindow(DarkToolBarUIBridge.this.toolBar);
                }
                if (DarkToolBarUIBridge.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)DarkToolBarUIBridge.this.floatingToolBar)).setVisible(false);
                }
                DarkToolBarUIBridge.this.floatingToolBar.getContentPane().remove(DarkToolBarUIBridge.this.toolBar);
                String constraint = DarkToolBarUIBridge.this.constraintBeforeFloating;
                if (DarkToolBarUIBridge.this.toolBar.getOrientation() == 0) {
                    if (Objects.equals(constraint, "West") || Objects.equals(constraint, "East")) {
                        constraint = "North";
                    }
                } else if (Objects.equals(constraint, "North") || Objects.equals(constraint, "South")) {
                    constraint = "West";
                }
                if (DarkToolBarUIBridge.this.dockingSource == null) {
                    DarkToolBarUIBridge.this.dockingSource = DarkToolBarUIBridge.this.toolBar.getParent();
                }
                if (DarkToolBarUIBridge.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(DarkToolBarUIBridge.this.propertyListener);
                }
                DarkToolBarUIBridge.this.dockingSource.add((Component)DarkToolBarUIBridge.this.toolBar, constraint);
                DarkToolBarUIBridge.this.dockingSource.invalidate();
                Container dockingSourceParent = DarkToolBarUIBridge.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    dockingSourceParent.validate();
                }
                DarkToolBarUIBridge.this.dockingSource.repaint();
            }
        }
    }
}

