/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;

public class DarkToolBarLayout
implements LayoutManager2,
Serializable,
PropertyChangeListener,
UIResource {
    protected final JToolBar toolBar;
    protected BoxLayout lm;

    public DarkToolBarLayout(JToolBar toolBar) {
        this.toolBar = toolBar;
        toolBar.addPropertyChangeListener(this);
        this.lm = toolBar.getOrientation() == 1 ? new BoxLayout(toolBar, 3) : new BoxLayout(toolBar, 2);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.lm.addLayoutComponent(name, comp);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.lm.addLayoutComponent(comp, constraints);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.lm.removeLayoutComponent(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.lm.preferredLayoutSize(target);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.lm.minimumLayoutSize(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.lm.maximumLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        this.lm.layoutContainer(target);
        Dimension size = target.getSize();
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component c = target.getComponent(i);
            Rectangle bounds = c.getBounds();
            if (!(c instanceof JSeparator)) continue;
            if (this.toolBar.getOrientation() == 0) {
                c.setBounds(bounds.x, size.height / 2 - bounds.height / 2, bounds.width, bounds.height);
                continue;
            }
            c.setBounds(size.width / 2 - bounds.width / 2, bounds.y, bounds.width, bounds.height);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return this.lm.getLayoutAlignmentX(target);
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return this.lm.getLayoutAlignmentY(target);
    }

    @Override
    public void invalidateLayout(Container target) {
        this.lm.invalidateLayout(target);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("orientation")) {
            int o = (Integer)e.getNewValue();
            this.lm = o == 1 ? new BoxLayout(this.toolBar, 3) : new BoxLayout(this.toolBar, 2);
        }
    }
}

