/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.taskpane;

import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;
import org.jdesktop.swingx.plaf.metal.MetalTaskPaneUI;

public class DarkTaskPaneUI
extends MetalTaskPaneUI {
    public static final String KEY_COLLAPSED = "collapsed";
    protected boolean isCollapsed;
    protected Color borderColor;
    protected Icon collapsedIcon;
    protected Icon openIcon;
    protected int arc;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTaskPaneUI();
    }

    @Override
    protected void installDefaults() {
        this.borderColor = UIManager.getColor("TaskPane.borderColor");
        this.arc = UIManager.getInt("TaskPane.arc");
        this.collapsedIcon = UIManager.getIcon("TaskPane.collapsed.icon");
        this.openIcon = UIManager.getIcon("TaskPane.open.icon");
        super.installDefaults();
    }

    @Override
    protected Border createPaneBorder() {
        return new DarkPaneBorder();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.group.addPropertyChangeListener("animationState", e -> {
            this.isCollapsed = KEY_COLLAPSED.equals(e.getNewValue());
        });
    }

    @Override
    protected Border createContentPaneBorder() {
        return new CompoundBorder(new DarkContentPaneBorder(this.borderColor, this.arc), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    @Override
    protected void configure(JXHyperlink link) {
        super.configure(link);
        link.setFocusPainted(false);
    }

    @Override
    protected int getRoundHeight() {
        return this.arc;
    }

    protected boolean isCollapsed() {
        if (!this.group.isAnimated()) {
            return this.group.isCollapsed();
        }
        return this.isCollapsed;
    }

    protected class DarkPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected DarkPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            Graphics2D g = (Graphics2D)g2;
            int w = group.getWidth();
            int h = DarkTaskPaneUI.this.getTitleHeight(group);
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            if (DarkTaskPaneUI.this.isCollapsed()) {
                DarkUIUtil.fillRoundRect(g, 1.0f, 1.0f, w - 2, h - 2, DarkTaskPaneUI.this.getRoundHeight());
                g.setColor(this.borderColor);
                DarkUIUtil.paintLineBorder(g, 1.0f, 1.0f, w - 2, h - 2, DarkTaskPaneUI.this.getRoundHeight());
            } else {
                Rectangle clip = g.getClip().getBounds();
                g.setClip(0, 0, w, h / 2 + 1);
                DarkUIUtil.fillRoundRect(g, 1.0f, 1.0f, w - 2, h - 2, DarkTaskPaneUI.this.getRoundHeight());
                g.setClip(0, h / 2 - 1, w, h / 2 + 2);
                g.fillRect(0, 0, w, h);
                g.setColor(this.borderColor);
                g.setClip(0, 0, w, h / 2 + 1);
                DarkUIUtil.paintLineBorder(g, 1.0f, 1.0f, w - 2, h - 2, DarkTaskPaneUI.this.getRoundHeight());
                g.setClip(0, h / 2 - 1, w, h / 2 + 2);
                DarkUIUtil.drawRect(g, 0, 0, w, h, 1);
                g.setClip(clip);
            }
        }

        @Override
        protected void configureLabel(JXTaskPane group) {
            super.configureLabel(group);
            this.label.setFont(this.label.getFont().deriveFont(0));
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getPaintColor(group));
            if (group.isCollapsed()) {
                DarkTaskPaneUI.this.collapsedIcon.paintIcon(group, g, x, y);
            } else {
                DarkTaskPaneUI.this.openIcon.paintIcon(group, g, x, y);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }

    protected static class DarkContentPaneBorder
    implements Border,
    UIResource {
        protected Color color;
        protected int arc;

        public DarkContentPaneBorder(Color color, int arc) {
            this.arc = arc;
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle clip = g.getClip().getBounds();
            int h = height + this.arc;
            g.setClip(clip.x, clip.y, width, h / 2 + 1);
            g.setColor(this.color);
            DarkUIUtil.drawRect(g, x, y - 1, width, h, 1);
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                g.setClip(clip.x, clip.x + h - this.arc, width, this.arc);
                DarkUIUtil.fillRoundRect((Graphics2D)g, x - 1, y, width - 2, h - 1, this.arc);
            }
            g.setClip(clip.x, clip.y + h / 2 - 1, width, h / 2 + 2);
            g.setColor(this.color);
            DarkUIUtil.paintLineBorder((Graphics2D)g, x + 1, y, width - 2, h - 1, this.arc);
            g.setClip(clip);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

