/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.table.DarkTableCellBorder;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class TextTableCellEditorBorder
extends DarkTableCellBorder {
    protected Color borderColor = UIManager.getColor("TextField.border.enabled");

    protected static boolean parentLTR(Component c) {
        return c.getParent().getComponentOrientation().isLeftToRight();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.borderColor);
        JTable table = DarkUIUtil.getParentOfType(JTable.class, c);
        if (table != null) {
            int row = table.getEditingRow();
            if (!table.getShowHorizontalLines()) {
                if (row > this.getMinRowIndex(table)) {
                    g.fillRect(0, 0, width, 1);
                }
                g.fillRect(0, height - 1, width, 1);
            }
            if (!table.getShowVerticalLines()) {
                g.fillRect(0, 0, 1, height);
                g.fillRect(width - 1, 0, 1, height);
            } else if (TextTableCellEditorBorder.isInWrapper(c)) {
                if (c.getParent().getComponentOrientation().isLeftToRight()) {
                    g.fillRect(0, 0, 1, height);
                } else {
                    g.fillRect(width - 1, 0, 1, height);
                }
            }
        } else {
            DarkUIUtil.drawRect(g, x, y, width, height, 1);
        }
    }

    protected int getMinColumnIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.columnAtPoint(rect.getLocation());
    }

    protected int getMinRowIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.rowAtPoint(rect.getLocation());
    }

    protected static boolean isListEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTextComponent.listCellEditor")) && c.getParent() instanceof JList;
    }

    protected static boolean isInWrapper(Component c) {
        return c.getParent() instanceof DarkTableCellEditor.IconWrapper;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        ListCellRenderer renderer;
        Insets ins = super.getBorderInsets();
        if (TextTableCellEditorBorder.isInWrapper(c)) {
            if (TextTableCellEditorBorder.parentLTR(c)) {
                ins.left -= ((DarkTableCellEditor.IconWrapper)c.getParent()).getIconCompGap();
            } else {
                ins.right -= ((DarkTableCellEditor.IconWrapper)c.getParent()).getIconCompGap();
            }
        } else if (TextTableCellEditorBorder.isListEditor(c) && (renderer = ((JList)c.getParent()).getCellRenderer()) instanceof JLabel) {
            if (TextTableCellEditorBorder.parentLTR(c)) {
                ins.left -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            } else {
                ins.right -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            }
        }
        JTable table = DarkUIUtil.getParentOfType(JTable.class, c);
        if (table != null && !table.getShowVerticalLines() && table.getEditingColumn() > this.getMinColumnIndex(table)) {
            ++ins.left;
        }
        return ins;
    }
}

