/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.PanelPopup;
import com.github.weisj.darklaf.components.tabframe.PopupContainer;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.uiresource.JLabelUIResource;
import com.github.weisj.darklaf.ui.panel.DarkPanelUI;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class DarkPanelPopupUI
extends DarkPanelUI
implements PropertyChangeListener,
AWTEventListener {
    protected HeaderButton closeButton;
    private final Action closeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DarkPanelPopupUI.this.closeButton.doClick();
        }
    };
    protected JPanel content;
    protected JLabel label;
    protected Color headerFocusBackground;
    protected Color headerButtonFocusHoverBackground;
    protected Color headerButtonFocusClickBackground;
    protected Color headerBackground;
    protected Color headerButtonHoverBackground;
    protected Color headerButtonClickBackground;
    protected String accelerator;
    private PanelPopup popupComponent;
    private JPanel header;
    private MutableLineBorder headerBorder;
    private MutableLineBorder contentBorder;
    private boolean oldFocus;

    public static ComponentUI createUI(JComponent c) {
        return new DarkPanelPopupUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.popupComponent = (PanelPopup)c;
        super.installUI(c);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installDefaults() {
        this.headerBackground = UIManager.getColor("TabFramePopup.headerBackground");
        this.headerButtonHoverBackground = UIManager.getColor("TabFramePopup.headerButtonHoverBackground");
        this.headerButtonClickBackground = UIManager.getColor("TabFramePopup.headerButtonClickBackground");
        this.headerFocusBackground = UIManager.getColor("TabFramePopup.headerFocusBackground");
        this.headerButtonFocusHoverBackground = UIManager.getColor("TabFramePopup.headerButtonFocusHoverBackground");
        this.headerButtonFocusClickBackground = UIManager.getColor("TabFramePopup.headerButtonFocusClickBackground");
        this.accelerator = UIManager.getString("TabFramePopup.closeAccelerator");
        this.popupComponent.getInputMap(1).put(KeyStroke.getKeyStroke(this.accelerator), this.accelerator);
        this.popupComponent.getActionMap().put(this.accelerator, this.closeAction);
        this.popupComponent.setLayout(new BorderLayout());
    }

    protected void installComponents() {
        this.closeButton = this.createCloseButton();
        this.label = this.createLabel();
        this.header = this.createHeader();
        JPanel headerContainer = new JPanel(new BorderLayout());
        this.setHeaderBackground(false);
        headerContainer.add((Component)this.header, "Center");
        headerContainer.setMinimumSize(UIManager.getDimension("TabFramePopup.minimumHeaderSize"));
        this.content = new JPanel(new BorderLayout());
        this.content.add(this.popupComponent.getContentPane(), "Center");
        this.popupComponent.setLayout(new BorderLayout());
        this.popupComponent.add((Component)headerContainer, "North");
        this.popupComponent.add((Component)this.content, "Center");
        this.headerBorder = this.createBorder();
        this.contentBorder = this.createBorder();
        headerContainer.setBorder(this.headerBorder);
        this.content.setBorder(this.contentBorder);
    }

    protected void installListeners() {
        this.popupComponent.addPropertyChangeListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
        JTabFrame frame = this.popupComponent.getTabFrame();
        if (frame != null) {
            frame.addPropertyChangeListener(this);
        }
    }

    protected HeaderButton createCloseButton() {
        HeaderButton closeButton = new HeaderButton(UIManager.getIcon("TabFramePopup.close.icon"), this);
        closeButton.setBorder(new EmptyBorder(4, 4, 4, 4));
        closeButton.addActionListener(e -> this.popupComponent.close());
        String tooltip = UIManager.getString("TabFramePopup.closeTooltipText");
        closeButton.setToolTipText(tooltip);
        return closeButton;
    }

    protected JLabel createLabel() {
        JLabelUIResource label = new JLabelUIResource(this.popupComponent.getTitle(), this.popupComponent.getIcon(), 2);
        label.setOpaque(false);
        return label;
    }

    protected JPanel createHeader() {
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 0));
        header.add(Box.createHorizontalStrut(5));
        header.add(this.label);
        header.add(Box.createGlue());
        header.add(this.closeButton);
        header.add(Box.createHorizontalStrut(1));
        header.setBorder(UIManager.getBorder("TabFramePopup.headerBorder"));
        return header;
    }

    protected void setHeaderBackground(boolean focus) {
        this.closeButton.setFocus(focus);
        if (this.header != null) {
            this.header.setBackground(focus ? this.headerFocusBackground : this.headerBackground);
        }
        if (this.oldFocus != focus) {
            if (this.header != null) {
                this.header.repaint();
            }
            this.closeButton.repaint();
            this.oldFocus = focus;
        }
    }

    protected MutableLineBorder createBorder() {
        Color color = UIManager.getColor("TabFramePopup.borderColor");
        return new MutableLineBorder.UIResource(0, 0, 0, 0, color);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallComponents();
        this.uninstallListeners();
        this.popupComponent.getInputMap(1).remove(KeyStroke.getKeyStroke(this.accelerator));
        this.popupComponent.getActionMap().remove(this.accelerator);
        this.popupComponent = null;
    }

    protected void uninstallComponents() {
        this.popupComponent.removeAll();
    }

    protected void uninstallListeners() {
        this.popupComponent.removePropertyChangeListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        JTabFrame frame = this.popupComponent.getTabFrame();
        if (frame != null) {
            frame.removePropertyChangeListener(this);
        }
    }

    @Override
    public final Dimension getPreferredSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getMaximumSize(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("open".equals(key)) {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.setHeaderBackground(true);
            }
        } else if ("content".equals(key)) {
            if (this.content == null) {
                return;
            }
            this.content.add((Component)evt.getNewValue(), "Center");
            this.content.invalidate();
        } else if ("title".equals(key)) {
            if (this.label == null) {
                return;
            }
            this.label.setText(evt.getNewValue().toString());
            this.label.repaint();
        } else if ("icon".equals(key)) {
            if (this.label == null) {
                return;
            }
            this.label.setIcon((Icon)evt.getNewValue());
            this.label.repaint();
        } else if ("visibleTab".equals(key)) {
            if (evt.getNewValue() instanceof JTabFrame.TabFramePosition && ((JTabFrame.TabFramePosition)evt.getNewValue()).getAlignment() == this.popupComponent.getAlignment()) {
                this.updateBorder(true);
            }
        } else if ("tabFrame".equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof JTabFrame) {
                ((JTabFrame)oldVal).removePropertyChangeListener(this);
            }
            if (newVal instanceof JTabFrame) {
                ((JTabFrame)newVal).addPropertyChangeListener(this);
            }
        } else if ("peerInsets".equals(key)) {
            this.updateBorder(false);
            this.updateTooltip();
        } else if ("alignment".equals(key)) {
            this.updateTooltip();
        }
    }

    protected void updateBorder(boolean notifyPeer) {
        if (this.popupComponent.getTabFrame() != null) {
            JTabFrame tabFrame = this.popupComponent.getTabFrame();
            boolean[] status = tabFrame.getContentPane().getStatus();
            Alignment alignment = this.popupComponent.getAlignment();
            Insets insets = this.getBorderSize(alignment, status);
            this.applyBorderInsets(insets);
            this.popupComponent.doLayout();
            this.popupComponent.repaint();
            if (notifyPeer) {
                try {
                    Component peer = tabFrame.getPopupComponentAt(tabFrame.getPeer(this.popupComponent.getAlignment()));
                    peer.firePropertyChange("peerInsets", 0L, 1L);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    protected void updateTooltip() {
        JTabFrame tabFrame = this.popupComponent.getTabFrame();
        this.closeButton.setAlignment(this.popupComponent.getAlignment(), tabFrame.getContentPane().isEnabled(tabFrame.getPeer(this.popupComponent.getAlignment())));
    }

    protected Insets getBorderSize(Alignment a, boolean[] info) {
        Insets insets = new Insets(0, 0, 0, 0);
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                if (info[Alignment.NORTH.getIndex()] || info[Alignment.NORTH_EAST.getIndex()]) {
                    insets.bottom = 1;
                }
                if (info[Alignment.NORTH.getIndex()] && a == Alignment.NORTH_EAST) {
                    insets.left = 1;
                }
                return insets;
            }
            case SOUTH: 
            case SOUTH_WEST: {
                if (info[Alignment.SOUTH_WEST.getIndex()] || info[Alignment.SOUTH.getIndex()]) {
                    insets.top = 1;
                }
                if (info[Alignment.SOUTH_WEST.getIndex()] && a == Alignment.SOUTH) {
                    insets.left = 1;
                }
                return insets;
            }
            case EAST: 
            case SOUTH_EAST: {
                if (info[Alignment.EAST.getIndex()] || info[Alignment.SOUTH_EAST.getIndex()]) {
                    insets.left = 1;
                }
                if (info[Alignment.EAST.getIndex()] && a == Alignment.SOUTH_EAST) {
                    insets.top = 1;
                }
                return insets;
            }
            case WEST: 
            case NORTH_WEST: {
                if (info[Alignment.NORTH_WEST.getIndex()] || info[Alignment.WEST.getIndex()]) {
                    insets.right = 1;
                }
                if (info[Alignment.NORTH_WEST.getIndex()] && a == Alignment.WEST) {
                    insets.top = 1;
                }
                return insets;
            }
        }
        return insets;
    }

    protected void applyBorderInsets(Insets insets) {
        this.headerBorder.setInsets(insets.top, insets.left, 1, insets.right);
        this.contentBorder.setInsets(0, insets.left, insets.bottom, insets.right);
    }

    protected boolean hasFocus() {
        return this.oldFocus;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 1004) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (focusOwner instanceof JTabFrame) {
                return;
            }
            if (focusOwner instanceof JRootPane) {
                return;
            }
            boolean focus = DarkUIUtil.hasFocus(this.popupComponent);
            if (this.popupComponent.getTabFrame() != null) {
                PopupContainer container = this.popupComponent.getTabFrame().getContentPane().getContainer(this.popupComponent.getAlignment());
                focus = focus || DarkUIUtil.hasFocus(container);
            }
            this.setHeaderBackground(focus);
        }
    }

    protected static final class HeaderButton
    extends JButton
    implements UIResource {
        protected final ToolTipContext context = new ToolTipContext(this);
        protected final DarkPanelPopupUI ui;

        public HeaderButton(Icon icon, DarkPanelPopupUI ui) {
            super(icon);
            this.ui = ui;
            this.putClientProperty("JButton.square", true);
            this.putClientProperty("JButton.alternativeArc", Boolean.TRUE);
            this.putClientProperty("JButton.variant", "shadow");
            this.setRolloverEnabled(true);
            this.setMargin(UIManager.getInsets("TabFramePopup.headerButton.insets"));
            this.setFocus(false);
            this.setOpaque(false);
            this.context.setToolTipInsets(UIManager.getInsets("TabFramePopup.headerButton.tooltipInsets"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.context != null) {
                this.context.updateToolTipUI();
            }
        }

        public void setFocus(boolean focus) {
            this.putClientProperty("JButton.shadow.hover", focus ? this.ui.headerButtonFocusHoverBackground : this.ui.headerButtonHoverBackground);
            this.putClientProperty("JButton.shadow.click", focus ? this.ui.headerButtonFocusClickBackground : this.ui.headerButtonClickBackground);
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return this.context.getToolTipLocation(event);
        }

        @Override
        public JToolTip createToolTip() {
            return this.context.getToolTip();
        }

        protected void setAlignment(Alignment a, boolean peerEnabled) {
            switch (a) {
                case NORTH: {
                    this.context.setCenterAlignment(peerEnabled ? Alignment.SOUTH : Alignment.SOUTH_WEST);
                    break;
                }
                case NORTH_EAST: {
                    this.context.setCenterAlignment(Alignment.SOUTH_WEST);
                    break;
                }
                case EAST: {
                    this.context.setCenterAlignment(Alignment.WEST);
                    break;
                }
                case SOUTH_EAST: {
                    this.context.setCenterAlignment(Alignment.WEST);
                    break;
                }
                case SOUTH: {
                    this.context.setCenterAlignment(Alignment.NORTH_WEST);
                    break;
                }
                case SOUTH_WEST: {
                    this.context.setCenterAlignment(peerEnabled ? Alignment.NORTH : Alignment.NORTH_WEST);
                    break;
                }
                case WEST: {
                    this.context.setCenterAlignment(peerEnabled ? Alignment.NORTH : Alignment.SOUTH);
                    break;
                }
                case NORTH_WEST: {
                    this.context.setCenterAlignment(Alignment.SOUTH);
                    break;
                }
            }
        }
    }
}

