/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.numberingpane;

import com.github.weisj.darklaf.components.text.IconListener;
import com.github.weisj.darklaf.components.text.IndexListener;
import com.github.weisj.darklaf.components.text.LineHighlighter;
import com.github.weisj.darklaf.components.text.NumberingPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class DarkNumberingPaneUI
extends ComponentUI {
    protected static final int OUTER_PAD = 7;
    protected static final int PAD = 5;
    protected Handler handler;
    protected NumberingPane numberingPane;
    protected Color backgroundHighlight;
    protected Color foregroundHighlight;
    protected LineHighlighter currentLinePainter;
    protected int textWidth = 0;
    protected JTextComponent textComponent;
    protected JViewport viewport;
    protected int maxIconWidth = 0;
    protected Color oldBackground;

    public static ComponentUI createUI(JComponent c) {
        return new DarkNumberingPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.numberingPane = (NumberingPane)c;
        super.installUI(c);
        this.installDefaults(c);
        this.installListeners(c);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "NumberingPane.background", "NumberingPane.foreground", "NumberingPane.font");
        this.foregroundHighlight = UIManager.getColor("NumberingPane.currentLineForeground");
        this.backgroundHighlight = UIManager.getColor("NumberingPane.currentLineBackground");
        LookAndFeel.installProperty(c, "opaque", true);
        LookAndFeel.installBorder(c, "NumberingPane.border");
    }

    protected void installListeners(JComponent c) {
        this.currentLinePainter = new LineHighlighter(null, this.backgroundHighlight);
        this.numberingPane.addMouseListener(this.getMouseListener());
        this.numberingPane.addMouseMotionListener(this.getMouseMotionListener());
        this.numberingPane.addPropertyChangeListener(this.getPropertyChangeListener());
    }

    protected MouseListener getMouseListener() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseMotionListener getMouseMotionListener() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(c);
        this.currentLinePainter.setComponent(null);
        this.currentLinePainter = null;
        this.numberingPane = null;
    }

    protected void uninstallListeners(JComponent c) {
        if (this.textComponent != null) {
            this.textComponent.getCaret().removeChangeListener(this.getChangeListener());
            this.textComponent.getCaret().removeChangeListener(this.currentLinePainter);
            this.textComponent.removePropertyChangeListener(this.getPropertyChangeListener());
        }
        this.numberingPane.removePropertyChangeListener(this.getPropertyChangeListener());
        this.numberingPane.removeMouseListener(this.getMouseListener());
        this.numberingPane.removeMouseMotionListener(this.getMouseMotionListener());
    }

    protected ChangeListener getChangeListener() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.textComponent == null || this.viewport == null) {
            return;
        }
        FontMetrics metrics = this.textComponent.getFontMetrics(this.textComponent.getFont());
        int descent = metrics.getDescent();
        Document doc = this.textComponent.getDocument();
        Rectangle viewRect = this.viewport.getViewRect();
        Point p = viewRect.getLocation();
        int startIndex = this.textComponent.viewToModel(p);
        p.y += viewRect.height;
        int endIndex = this.textComponent.viewToModel(p);
        int currOffset = this.textComponent.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int startLine = root.getElementIndex(startIndex);
        int endLine = root.getElementIndex(endIndex);
        int yCurr = this.drawHighlightBackground(g, currOffset);
        this.drawNumbering(g, startLine, endLine, yCurr, root, descent);
        this.paintIcons(g, startLine, endLine, root);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.textComponent == null || this.viewport == null) {
            return super.getPreferredSize(c);
        }
        int lines = this.textComponent.getDocument().getDefaultRootElement().getElementCount();
        int pad = 14;
        if (this.maxIconWidth > 0) {
            pad += 5;
        }
        this.textWidth = this.numberingPane.getFontMetrics(this.numberingPane.getFont()).stringWidth(String.valueOf(lines));
        return new Dimension(this.maxIconWidth + pad + this.textWidth, this.viewport.getView().getHeight());
    }

    protected int drawHighlightBackground(Graphics g, int currOffset) {
        Rectangle rect;
        g.setColor(this.backgroundHighlight);
        try {
            rect = this.textComponent.modelToView(currOffset).getBounds();
        }
        catch (BadLocationException e) {
            rect = new Rectangle(0, 0, 0, 0);
        }
        g.fillRect(0, rect.y, this.numberingPane.getWidth(), rect.height);
        return rect.y;
    }

    protected void drawNumbering(Graphics g, int startLine, int endLine, int yCur, Element root, int descent) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        g.setColor(this.numberingPane.getForeground());
        int digits = String.valueOf(root.getElementCount()).length();
        for (int i = startLine; i <= endLine; ++i) {
            int off = root.getElement(i).getStartOffset();
            try {
                Rectangle lineRect = this.textComponent.modelToView(off);
                g.setColor(lineRect.y == yCur ? this.foregroundHighlight : this.numberingPane.getForeground());
                g.drawString(String.format("%1$" + digits + "d", i), 7, lineRect.y + lineRect.height - descent);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        config.restore();
    }

    protected void paintIcons(Graphics g, int startLine, int endLine, Element root) {
        List<Map.Entry<Position, Icon>> icons = this.numberingPane.getIconsInRange(root.getElement(startLine).getStartOffset(), root.getElement(endLine).getEndOffset());
        for (Map.Entry<Position, Icon> icon : icons) {
            try {
                Rectangle lineRect = this.textComponent.modelToView(icon.getKey().getOffset());
                int h = icon.getValue().getIconHeight();
                int x = 12 + this.textWidth;
                int y = lineRect.y + lineRect.height / 2 - h / 2;
                icon.getValue().paintIcon(this.numberingPane, g, x, y);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected int calculateMaxIconWidth() {
        Collection<Icon> icons = this.numberingPane.getIcons();
        int max = this.numberingPane.getMinimumIconWidth();
        for (Icon icon : icons) {
            max = Math.max(icon.getIconWidth(), max);
        }
        return max;
    }

    protected class Handler
    extends MouseAdapter
    implements PropertyChangeListener,
    ChangeListener {
        protected int selectionLineStart;
        protected int selectionLineEnd;
        protected Object currentHighlight;

        protected Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DarkNumberingPaneUI.this.textComponent == null) {
                return;
            }
            Point p = e.getPoint();
            int width = DarkNumberingPaneUI.this.numberingPane.getWidth();
            if (p.x > 12 + DarkNumberingPaneUI.this.textWidth && p.x <= width - 5) {
                IndexListener[] list;
                int endOffset;
                int offset = DarkNumberingPaneUI.this.textComponent.viewToModel(new Point(0, p.y));
                Document doc = DarkNumberingPaneUI.this.textComponent.getDocument();
                int start = doc.getDefaultRootElement().getElementIndex(offset);
                int startOffset = doc.getDefaultRootElement().getElement(start).getStartOffset();
                List<Map.Entry<Position, Icon>> icons = DarkNumberingPaneUI.this.numberingPane.getIconsInRange(startOffset, endOffset = doc.getDefaultRootElement().getElement(start).getEndOffset());
                if (!icons.isEmpty()) {
                    Icon icon = icons.get(0).getValue();
                    try {
                        Rectangle lineRect = DarkNumberingPaneUI.this.textComponent.modelToView(start).getBounds();
                        int h = icon.getIconHeight();
                        int x = 12 + DarkNumberingPaneUI.this.textWidth;
                        int y = lineRect.y + lineRect.height / 2 - h / 2;
                        if (p.x >= x && p.y >= y && p.y <= y + h) {
                            List<IconListener> list2 = DarkNumberingPaneUI.this.numberingPane.getIconListeners(startOffset, endOffset);
                            for (IconListener listener : list2) {
                                listener.iconClicked(e);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                for (IndexListener listener : list = DarkNumberingPaneUI.this.numberingPane.getIndexListeners()) {
                    listener.indexClicked(start, offset, e);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DarkNumberingPaneUI.this.textComponent == null) {
                return;
            }
            Point p = e.getPoint();
            this.selectionLineStart = DarkNumberingPaneUI.this.textComponent.viewToModel(new Point(0, p.y));
            this.selectionLineEnd = DarkNumberingPaneUI.this.textComponent.viewToModel(new Point(DarkNumberingPaneUI.this.textComponent.getWidth(), p.y));
            if (p.x <= 7 + DarkNumberingPaneUI.this.textWidth) {
                DarkNumberingPaneUI.this.textComponent.getCaret().setDot(this.selectionLineEnd + 1);
                DarkNumberingPaneUI.this.textComponent.getCaret().moveDot(Math.min(this.selectionLineStart, DarkNumberingPaneUI.this.textComponent.getDocument().getLength()));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.selectionLineStart = -1;
            this.selectionLineEnd = -1;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DarkNumberingPaneUI.this.numberingPane.getTextComponent() == null) {
                return;
            }
            JTextComponent textPane = DarkNumberingPaneUI.this.numberingPane.getTextComponent();
            Point p = e.getPoint();
            if (this.selectionLineEnd >= 0 && this.selectionLineStart >= 0) {
                int end = textPane.viewToModel(new Point(textPane.getWidth(), p.y));
                int start = textPane.viewToModel(new Point(0, p.y));
                if (this.selectionLineStart > end) {
                    textPane.getCaret().setDot(this.selectionLineEnd + 1);
                    textPane.getCaret().moveDot(Math.min(start, textPane.getDocument().getLength() - 1));
                } else {
                    textPane.getCaret().setDot(this.selectionLineStart);
                    textPane.getCaret().moveDot(Math.min(end + 1, textPane.getDocument().getLength()));
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DarkNumberingPaneUI.this.numberingPane.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String key = evt.getPropertyName();
            if ("caret".equals(key)) {
                if (evt.getNewValue() instanceof Caret) {
                    Object newCaret;
                    Object oldCaret = evt.getOldValue();
                    if (oldCaret instanceof Caret) {
                        ((Caret)oldCaret).removeChangeListener(DarkNumberingPaneUI.this.getChangeListener());
                        ((Caret)oldCaret).removeChangeListener(DarkNumberingPaneUI.this.currentLinePainter);
                    }
                    if ((newCaret = evt.getNewValue()) instanceof Caret) {
                        ((Caret)newCaret).addChangeListener(DarkNumberingPaneUI.this.getChangeListener());
                        ((Caret)newCaret).addChangeListener(DarkNumberingPaneUI.this.currentLinePainter);
                    }
                }
            } else if ("font".equals(key)) {
                Font font = DarkNumberingPaneUI.this.textComponent.getFont();
                DarkNumberingPaneUI.this.numberingPane.setFont(font.deriveFont(Math.max((float)(font.getSize() - 1), 1.0f)));
            } else if ("editorPane".equals(key)) {
                Object newPane = evt.getNewValue();
                if (DarkNumberingPaneUI.this.textComponent != null) {
                    DarkNumberingPaneUI.this.currentLinePainter.setComponent(null);
                    DarkNumberingPaneUI.this.textComponent.setBackground(DarkNumberingPaneUI.this.oldBackground);
                    DarkNumberingPaneUI.this.textComponent.getHighlighter().removeHighlight(this.currentHighlight);
                    DarkNumberingPaneUI.this.textComponent.getCaret().removeChangeListener(DarkNumberingPaneUI.this.getChangeListener());
                    DarkNumberingPaneUI.this.textComponent.getCaret().removeChangeListener(DarkNumberingPaneUI.this.currentLinePainter);
                    DarkNumberingPaneUI.this.textComponent.removePropertyChangeListener(DarkNumberingPaneUI.this.getPropertyChangeListener());
                }
                if (newPane instanceof JTextComponent) {
                    DarkNumberingPaneUI.this.textComponent = (JTextComponent)newPane;
                    try {
                        this.currentHighlight = DarkNumberingPaneUI.this.textComponent.getHighlighter().addHighlight(0, 0, DarkNumberingPaneUI.this.currentLinePainter);
                        DarkNumberingPaneUI.this.textComponent.getCaret().addChangeListener(DarkNumberingPaneUI.this.currentLinePainter);
                        DarkNumberingPaneUI.this.currentLinePainter.setComponent(DarkNumberingPaneUI.this.textComponent);
                    }
                    catch (BadLocationException newCaret) {
                        // empty catch block
                    }
                    DarkNumberingPaneUI.this.textComponent.addPropertyChangeListener(DarkNumberingPaneUI.this.getPropertyChangeListener());
                    DarkNumberingPaneUI.this.textComponent.getCaret().addChangeListener(DarkNumberingPaneUI.this.getChangeListener());
                    Font font = DarkNumberingPaneUI.this.textComponent.getFont();
                    DarkNumberingPaneUI.this.numberingPane.setFont(font.deriveFont(Math.max((float)(font.getSize() - 1), 1.0f)));
                    DarkNumberingPaneUI.this.oldBackground = DarkNumberingPaneUI.this.textComponent.getBackground();
                    DarkNumberingPaneUI.this.textComponent.setBackground(UIManager.getColor("NumberingPane.textBackground"));
                }
            } else if ("icons".equals(key)) {
                Object oldVal = evt.getOldValue();
                Object newVal = evt.getNewValue();
                if (oldVal instanceof Icon) {
                    DarkNumberingPaneUI.this.maxIconWidth = DarkNumberingPaneUI.this.calculateMaxIconWidth();
                }
                if (newVal instanceof Icon) {
                    DarkNumberingPaneUI.this.maxIconWidth = Math.max(DarkNumberingPaneUI.this.maxIconWidth, ((Icon)newVal).getIconWidth());
                }
            } else if ("ancestor".equals(key)) {
                if (evt.getSource() == DarkNumberingPaneUI.this.numberingPane) {
                    JScrollPane parent = DarkUIUtil.getParentOfType(JScrollPane.class, (Component)evt.getNewValue());
                    DarkNumberingPaneUI.this.viewport = parent != null ? parent.getViewport() : null;
                }
            } else if ("minimumIconWidth".equals(key)) {
                DarkNumberingPaneUI.this.maxIconWidth = DarkNumberingPaneUI.this.calculateMaxIconWidth();
            }
        }
    }
}

