/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.decorators.MouseDelegate;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import com.github.weisj.darklaf.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class DarkMenuUI
extends BasicMenuUI {
    protected Icon arrowIconHover;
    protected JMenu menu;
    protected MouseListener mouseListener;

    public static ComponentUI createUI(JComponent x) {
        return new DarkMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.menu = (JMenu)c;
        super.installUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        for (MouseListener listener : this.menu.getMouseListeners()) {
            if (!listener.getClass().getEnclosingClass().equals(BasicMenuUI.class)) continue;
            this.menu.removeMouseListener(listener);
            this.mouseListener = new MouseDelegate(listener){
                private boolean pressed;
                private boolean wasEnabled;
                {
                    this.pressed = false;
                    this.wasEnabled = false;
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MenuElement[] selectedPath;
                    MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                    for (MenuElement element : selectedPath = manager.getSelectedPath()) {
                        if (!element.equals(DarkMenuUI.this.menu)) continue;
                        return;
                    }
                    super.mouseEntered(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.pressed = true;
                    this.wasEnabled = DarkMenuUI.this.menu.isEnabled() && DarkMenuUI.this.menu.isSelected() && DarkMenuUI.this.menu.getPopupMenu().isShowing();
                    super.mousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!DarkMenuUI.this.menu.isEnabled()) {
                        return;
                    }
                    if (this.pressed && this.wasEnabled) {
                        this.pressed = false;
                        return;
                    }
                    super.mouseReleased(e);
                }
            };
            this.menu.addMouseListener(this.mouseListener);
            break;
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menu.removeMouseListener(this.mouseListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.acceleratorFont = UIManager.getFont("MenuItem.font");
        this.acceleratorForeground = UIManager.getColor("MenuItem.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("MenuItem.selectionForeground");
        this.arrowIconHover = UIManager.getIcon("MenuItem.arrowHover.icon");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.getArrowIcon(), this.selectionBackground, this.isSelected(c) ? this.selectionForeground : c.getForeground(), this.defaultTextIconGap);
    }

    protected Icon getArrowIcon() {
        boolean hover = this.menuItem.getModel().isArmed() || this.menuItem instanceof JMenu && this.menuItem.getModel().isSelected();
        return hover ? this.arrowIconHover : this.arrowIcon;
    }

    protected boolean isSelected(JComponent menuItem) {
        if (!(menuItem instanceof JMenuItem)) {
            return false;
        }
        return menuItem.isEnabled() && ((JMenuItem)menuItem).isArmed();
    }

    private static void rightAlignAccText(MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        Rectangle accRect = lr.getAccRect();
        ButtonModel model = lh.getMenuItem().getModel();
        if (model.isEnabled()) {
            accRect.x = lh.getViewRect().x + lh.getViewRect().width - lh.getMenuItem().getIconTextGap() - lr.getAccRect().width;
        }
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Font holdf = g.getFont();
        Color holdc = g.getColor();
        JMenuItem mi = (JMenuItem)c;
        g.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        DarkUIUtil.applyInsets(viewRect, mi.getInsets());
        MenuItemLayoutHelper lh = new MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, this.acceleratorDelimiter, mi.getComponentOrientation().isLeftToRight(), mi.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult lr = lh.layoutMenuItem();
        this.paintBackground(g, mi, background);
        this.paintCheckIcon(g, lh, lr, holdc, foreground);
        this.paintIcon(g, lh, lr, holdc);
        g.setColor(foreground);
        this.paintText(g, lh, lr);
        this.paintAccText(g, lh, lr);
        this.paintArrowIcon(g, lh, lr, foreground);
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintCheckIcon(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        if (lh.getCheckIcon() != null) {
            ButtonModel model = lh.getMenuItem().getModel();
            if (model.isArmed() || lh.getMenuItem() instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (lh.useCheckAndArrow()) {
                lh.getCheckIcon().paintIcon(lh.getMenuItem(), g, lr.getCheckRect().x, lr.getCheckRect().y);
            }
            g.setColor(holdc);
        }
    }

    protected void paintAccText(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        DarkMenuUI.rightAlignAccText(lh, lr);
        if (!StringUtil.isBlank(lh.getAccText())) {
            ButtonModel model = lh.getMenuItem().getModel();
            g.setFont(lh.getAccFontMetrics().getFont());
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
                } else {
                    g.setColor(lh.getMenuItem().getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
                    g.setColor(lh.getMenuItem().getBackground().darker());
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g, lh.getAccText(), lr.getAccRect().x - 1, lr.getAccRect().y + lh.getFontMetrics().getAscent() - 1);
                }
            } else {
                if (model.isArmed() || lh.getMenuItem() instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
            }
        }
        config.restore();
    }

    protected void paintIcon(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc) {
        if (lh.getIcon() != null) {
            Icon icon;
            ButtonModel model = lh.getMenuItem().getModel();
            if (!model.isEnabled()) {
                icon = lh.getMenuItem().getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = lh.getMenuItem().getPressedIcon();
                if (icon == null) {
                    icon = lh.getMenuItem().getIcon();
                }
            } else {
                icon = lh.getMenuItem().getIcon();
            }
            if (icon != null) {
                icon.paintIcon(lh.getMenuItem(), g, lr.getIconRect().x, lr.getIconRect().y);
                g.setColor(holdc);
            }
        }
    }

    protected void paintText(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        if (!StringUtil.isBlank(lh.getText())) {
            if (lh.getHtmlView() != null) {
                lh.getHtmlView().paint(g, lr.getTextRect());
            } else {
                this.paintText(g, lh.getMenuItem(), lr.getTextRect(), lh.getText());
            }
        }
        config.restore();
    }

    protected void paintArrowIcon(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color foreground) {
        if (lh.getArrowIcon() != null) {
            ButtonModel model = lh.getMenuItem().getModel();
            if (model.isArmed() || lh.getMenuItem() instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (lh.useCheckAndArrow()) {
                lh.getArrowIcon().paintIcon(lh.getMenuItem(), g, lr.getArrowRect().x, lr.getArrowRect().y);
            }
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight() + 1;
        boolean parentOpaque = menuItem.getParent().isOpaque();
        if (menuItem.isOpaque() && parentOpaque) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        }
    }
}

