/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class DarkComboPopup
extends BasicComboPopup {
    private final AdjustmentListener adjustmentListener = e -> {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.list);
        MouseEvent ev = new MouseEvent(this.list, 503, 0L, 0, p.x, p.y, 1, false, 0);
        for (MouseMotionListener ml : this.list.getMouseMotionListeners()) {
            if (ml == null) continue;
            ml.mouseMoved(ev);
        }
    };
    private double lastEvent;
    private boolean visible = false;
    private OverlayScrollPane overlayScrollPane;

    public DarkComboPopup(JComboBox combo) {
        super(combo);
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (this.list.getModel().getSize() != 0) {
            int height = this.list.getUI().getCellBounds(this.list, (int)0, (int)0).height;
            this.overlayScrollPane.getVerticalScrollBar().setUnitIncrement(height);
        }
        this.visible = true;
        this.overlayScrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        this.lastEvent = System.currentTimeMillis();
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuCanceled();
    }

    @Override
    protected JScrollPane createScroller() {
        this.overlayScrollPane = new OverlayScrollPane(this.list, 20, 31);
        this.overlayScrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.thin", Boolean.TRUE);
        return this.overlayScrollPane.getScrollPane();
    }

    @Override
    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setOpaque(false);
        this.add(this.overlayScrollPane);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    @Override
    protected void configureList() {
        super.configureList();
    }

    @Override
    protected void togglePopup() {
        if (this.comboBox.getItemCount() == 0) {
            return;
        }
        if (this.visible) {
            this.visible = false;
            this.hide();
        } else if (this.lastEvent == 0.0 || (double)System.currentTimeMillis() - this.lastEvent > 250.0) {
            this.visible = true;
            SwingUtilities.invokeLater(this::show);
        }
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
    }

    protected void reset() {
        this.lastEvent = 0.0;
        if (this.visible) {
            this.hide();
        }
        this.visible = false;
    }
}

