/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class SlideComponent
extends JComponent
implements ColorListener {
    private static final int OFFSET = 11;
    private final ToolTipContext toolTipContext = new ToolTipContext(this);
    private final boolean vertical;
    private final String title;
    private final List<Consumer<Integer>> listeners = new ArrayList<Consumer<Integer>>();
    protected Color borderColor;
    protected Color shadowColor;
    protected Color knobFill;
    private boolean isOpacity;
    private int pointerValue = 0;
    private int value = 0;
    private Unit unitType = Unit.LEVEL;
    private Color color;

    SlideComponent(String title, boolean vertical, boolean isOpacity) {
        this.title = title;
        this.vertical = vertical;
        this.isOpacity = isOpacity;
        this.color = Color.WHITE;
        this.borderColor = UIManager.getColor("ColorChooser.sliderBorderColor");
        this.shadowColor = UIManager.getColor("ColorChooser.sliderShadow");
        this.knobFill = UIManager.getColor("ColorChooser.sliderKnobColor");
        this.toolTipContext.setAlignInside(false).setAlignment(vertical ? Alignment.WEST : Alignment.NORTH).setHideOnExit(false).setToolTipRectSupplier(e -> this.getKnobRect()).setToolTipInsets(new Insets(3, 0, 3, 0));
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SlideComponent.this.processMouse(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SlideComponent.this.processMouse(e);
            }
        });
        this.addMouseWheelListener(event -> {
            int units = event.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            int pointerValue = this.pointerValue + units;
            pointerValue = Math.max(pointerValue, 11);
            int size = this.vertical ? this.getHeight() : this.getWidth();
            this.pointerValue = pointerValue = Math.min(pointerValue, size - 12);
            this.value = this.pointerValueToValue(this.pointerValue);
            this.repaint();
            this.fireValueChanged();
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SlideComponent.this.setValue(SlideComponent.this.getValue());
                SlideComponent.this.fireValueChanged();
                SlideComponent.this.repaint();
            }
        });
        this.setToolTipText(this.getToolTipText(null));
    }

    private Rectangle getKnobRect() {
        if (this.vertical) {
            return new Rectangle(1, this.pointerValue - 6, 12, 12);
        }
        return new Rectangle(this.pointerValue - 6, 1, 12, 12);
    }

    private void processMouse(MouseEvent e) {
        int pointerValue = this.vertical ? e.getY() : e.getX();
        pointerValue = Math.max(pointerValue, 11);
        int size = this.vertical ? this.getHeight() : this.getWidth();
        this.pointerValue = pointerValue = Math.min(pointerValue, size - 12);
        this.value = this.pointerValueToValue(this.pointerValue);
        this.repaint();
        this.fireValueChanged();
    }

    private int pointerValueToValue(int pointerValue) {
        int size = this.vertical ? this.getHeight() : this.getWidth();
        double proportion = (float)(size - 23) / 255.0f;
        return (int)Math.round((double)(pointerValue -= 11) / proportion);
    }

    private void fireValueChanged() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this);
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this, 503, 0L, 0, p.x, p.y, 0, false, 0));
        for (Consumer<Integer> listener : this.listeners) {
            listener.accept(this.value);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value " + value + " not in range [0,255]");
        }
        this.pointerValue = this.valueToPointerValue(value);
        this.value = value;
    }

    private int valueToPointerValue(int value) {
        int size = this.vertical ? this.getHeight() : this.getWidth();
        float proportion = (float)(size - 23) / 255.0f;
        return 11 + (int)((float)value * proportion);
    }

    void setUnits(Unit unit) {
        this.unitType = unit;
    }

    public void addListener(Consumer<Integer> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.borderColor = UIManager.getColor("ColorChooser.sliderBorderColor");
        this.shadowColor = UIManager.getColor("ColorChooser.sliderShadow");
        this.knobFill = UIManager.getColor("ColorChooser.sliderKnobColor");
        if (this.toolTipContext != null) {
            this.toolTipContext.updateToolTipUI();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color endColor = this.isOpacity ? DarkUIUtil.TRANSPARENT_COLOR : Color.BLACK;
        Color beginColor = this.color;
        if (this.vertical) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, beginColor, 0.0f, this.getHeight(), endColor));
            g.fillRect(7, 10, 12, this.getHeight() - 20);
            g.setColor(this.borderColor);
            g.fillRect(7, 10, 12, 1);
            g.fillRect(7, 10, 1, this.getHeight() - 20);
            g.fillRect(18, 10, 1, this.getHeight() - 20);
            g.fillRect(7, 10 + this.getHeight() - 20 - 1, 12, 1);
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, endColor, this.getWidth(), 0.0f, beginColor));
            g.fillRect(10, 7, this.getWidth() - 20, 12);
            g.setColor(this.borderColor);
            g.fillRect(10, 7, 1, 12);
            g.fillRect(10, 7, this.getWidth() - 20, 1);
            g.fillRect(10, 18, this.getWidth() - 20, 1);
            g.fillRect(10 + this.getWidth() - 20 - 1, 7, 1, 12);
        }
        this.drawKnob(g2d, this.vertical ? 7 : this.pointerValue, this.vertical ? this.pointerValue : 7, this.vertical);
    }

    protected void drawKnob(Graphics2D g2d, int x, int y, boolean vertical) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (vertical) {
            Polygon arrowShadow = new Polygon();
            arrowShadow.addPoint(x - 5, (y -= 6) + 1);
            arrowShadow.addPoint(x + 7, y + 7);
            arrowShadow.addPoint(x - 5, y + 13);
            g2d.setColor(ColorUtil.toAlpha(this.shadowColor, 0.5));
            g2d.fill(arrowShadow);
            Polygon arrowHead = new Polygon();
            arrowHead.addPoint(x - 6, y);
            arrowHead.addPoint(x + 6, y + 6);
            arrowHead.addPoint(x - 6, y + 12);
            g2d.setColor(this.knobFill);
            g2d.fill(arrowHead);
        } else {
            Polygon arrowShadow = new Polygon();
            arrowShadow.addPoint((x -= 6) + 1, y - 5);
            arrowShadow.addPoint(x + 13, y - 5);
            arrowShadow.addPoint(x + 7, y + 7);
            g2d.setColor(ColorUtil.toAlpha(this.shadowColor, 0.5));
            g2d.fill(arrowShadow);
            Polygon arrowHead = new Polygon();
            arrowHead.addPoint(x, y - 6);
            arrowHead.addPoint(x + 12, y - 6);
            arrowHead.addPoint(x + 6, y + 6);
            g2d.setColor(this.knobFill);
            g2d.fill(arrowHead);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.vertical ? new Dimension(22, 100) : new Dimension(100, 22);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.vertical ? new Dimension(22, 50) : new Dimension(50, 22);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.title + ": " + Unit.formatValue(this.value, this.unitType);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.toolTipContext.getToolTipLocation(e);
    }

    @Override
    public JToolTip createToolTip() {
        return this.toolTipContext.getToolTip();
    }

    @Override
    public void colorChanged(Color color, Object source) {
        this.color = ColorUtil.removeAlpha(color);
        this.repaint();
    }

    static enum Unit {
        PERCENT,
        LEVEL;

        private static final float PERCENT_MAX_VALUE = 100.0f;
        private static final float LEVEL_MAX_VALUE = 255.0f;

        private static String formatValue(int value, Unit unit) {
            if (unit == PERCENT) {
                return String.format("%d%s", (int)(Unit.getMaxValue(unit) / 255.0f * (float)value), "%");
            }
            return String.format("%d", (int)(255.0f - Unit.getMaxValue(unit) / 255.0f * (float)value));
        }

        private static float getMaxValue(Unit unit) {
            return LEVEL.equals((Object)unit) ? 255.0f : 100.0f;
        }
    }
}

