/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.log;

import com.github.weisj.darklaf.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BOLD_ON = "\u001b[01m";
    public static final String ANSI_BOLD_OFF = "\u001b[2m";

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI_BLUE);
        String time = this.calculateDateString(record.getMillis());
        builder.append("[");
        builder.append(time);
        builder.append("]");
        builder.append(ANSI_YELLOW);
        builder.append(" [");
        builder.append(record.getLevel().getName());
        builder.append("]");
        builder.append(this.getMessageColor(record));
        builder.append(" ");
        builder.append(record.getMessage());
        builder.append(ANSI_WHITE);
        builder.append(ANSI_BOLD_ON);
        builder.append(" [at ");
        builder.append(record.getSourceClassName());
        builder.append("]");
        builder.append(ANSI_BOLD_OFF);
        Object[] params = record.getParameters();
        int spaceLength = time.length() + 3 + record.getLevel().getName().length() + 3;
        String space = StringUtil.repeat(" ", spaceLength);
        if (params != null) {
            builder.append("\n");
            builder.append(StringUtil.repeat(" ", spaceLength - 10));
            builder.append(ANSI_YELLOW);
            builder.append("[Details] ");
            builder.append(this.getMessageColor(record));
            for (int i = 0; i < params.length; ++i) {
                builder.append(params[i]);
                if (i >= params.length - 1) continue;
                builder.append(",\n");
                builder.append(space);
            }
        }
        builder.append(ANSI_RESET);
        builder.append("\n");
        return builder.toString();
    }

    private String calculateDateString(long milliseconds) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(milliseconds);
        return dateFormat.format(date);
    }

    private String getMessageColor(LogRecord record) {
        if (record.getLevel() == Level.SEVERE) {
            return ANSI_RED;
        }
        if (record.getLevel() == Level.WARNING) {
            return ANSI_YELLOW;
        }
        return ANSI_WHITE;
    }
}

