/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tooltip;

import com.github.weisj.darklaf.components.tooltip.ToolTipAware;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.util.Alignment;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class TooltipAwareButton
extends JButton
implements ToolTipAware {
    private ToolTipContext context;

    public TooltipAwareButton() {
        this(null, null);
    }

    public TooltipAwareButton(String text, Icon icon) {
        super(text, icon);
    }

    public TooltipAwareButton(Icon icon) {
        this(null, icon);
    }

    public TooltipAwareButton(String text) {
        this(text, null);
    }

    public TooltipAwareButton(Action a) {
        super(a);
    }

    @Override
    public void updateUI() {
        this.putClientProperty("JToolTip.toolTipContext", this.getToolTipContext());
        this.putClientProperty("JToolTip.style", (Object)ToolTipStyle.BALLOON);
        super.updateUI();
    }

    @Override
    public ToolTipContext getToolTipContext() {
        if (this.context == null) {
            this.context = new ToolTipContext().setAlignment(Alignment.SOUTH).setCenterAlignment(Alignment.SOUTH).setAlignInside(false).setIgnoreBorder(true);
        }
        return this.context;
    }
}

