/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LineHighlighter
implements Highlighter.HighlightPainter,
ChangeListener {
    private JTextComponent component;
    private Color color;
    private Rectangle lastView;

    public LineHighlighter(JTextComponent component, Color color) {
        this.component = component;
        this.lastView = new Rectangle(0, 0, 0, 0);
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Rectangle r = c.modelToView(c.getCaretPosition());
            g.setColor(this.color);
            g.fillRect(0, r.y, c.getWidth(), r.height);
            if (this.lastView == null) {
                this.lastView = r;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void setComponent(JTextComponent component) {
        this.component = component;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.resetHighlight();
    }

    private void resetHighlight() {
        if (this.component == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.component == null) {
                    return;
                }
                int offset = this.component.getCaretPosition();
                Rectangle view = this.component.modelToView(offset);
                if (view == null) {
                    return;
                }
                Rectangle currentView = view.getBounds();
                if (this.lastView != null && this.lastView.y != currentView.y) {
                    this.component.repaint(0, this.lastView.y, this.component.getWidth(), this.lastView.height);
                    this.lastView = currentView;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }
}

