/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.components.border.WeakLineBorder;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class DarkBorders {
    private static Map<WeakLineBorder, WeakReference<WeakLineBorder>> lineBorderMap = Collections.synchronizedMap(new WeakHashMap());
    private static Map<WeakLineBorder, WeakReference<WeakLineBorder>> lineWidgetBorderMap = Collections.synchronizedMap(new WeakHashMap());

    public static Border createLineBorder(int top, int left, int bottom, int right) {
        return DarkBorders.createBorder(top, left, bottom, right, lineBorderMap, "border");
    }

    private static Border createBorder(int top, int left, int bottom, int right, Map<WeakLineBorder, WeakReference<WeakLineBorder>> map, String key) {
        WeakLineBorder b;
        WeakReference<WeakLineBorder> ref;
        WeakLineBorder border = new WeakLineBorder(top, left, bottom, right);
        if (map.containsKey(border) && (ref = map.get(border)) != null && (b = (WeakLineBorder)ref.get()) != null) {
            return b;
        }
        border.setColor(UIManager.getColor(key));
        map.put(border, new WeakReference<WeakLineBorder>(border));
        return border;
    }

    public static Border createWidgetLineBorder(int top, int left, int bottom, int right) {
        return DarkBorders.createBorder(top, left, bottom, right, lineWidgetBorderMap, "borderSecondary");
    }

    public static void update(UIDefaults defaults) {
        Color borderColor = defaults.getColor("border");
        for (WeakReference<WeakLineBorder> border : lineBorderMap.values()) {
            WeakLineBorder b = (WeakLineBorder)border.get();
            if (b == null) continue;
            b.setColor(borderColor);
        }
        Color borderSecondaryColor = defaults.getColor("borderSecondary");
        for (WeakReference<WeakLineBorder> border : lineWidgetBorderMap.values()) {
            WeakLineBorder b = (WeakLineBorder)border.get();
            if (b == null) continue;
            b.setColor(borderSecondaryColor);
        }
    }
}

