/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.icons.UIAwareIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public final class ArrowButton
implements SwingConstants {
    private ArrowButton() {
    }

    public static JButton createUpDownArrow(JComponent parent, int orientation, boolean center) {
        return ArrowButton.createUpDownArrow(parent, orientation, center, false, new Insets(0, 0, 0, 0));
    }

    public static JButton createUpDownArrow(JComponent parent, int orientation, boolean center, boolean applyInsetsOnSize, Insets insets) {
        UIAwareIcon icon;
        switch (orientation) {
            case 1: {
                icon = (UIAwareIcon)UIManager.getIcon("ArrowButton.up.icon");
                break;
            }
            case 5: {
                icon = (UIAwareIcon)UIManager.getIcon("ArrowButton.down.icon");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid button orientation: " + orientation);
            }
        }
        return ArrowButton.createUpDownArrow(parent, icon, icon.getDual(), orientation, center, applyInsetsOnSize, insets);
    }

    public static JButton createUpDownArrow(final JComponent parent, final Icon activeIcon, final Icon inactiveIcon, int orientation, final boolean center, final boolean applyInsetsOnSize, final Insets insets) {
        return new BasicArrowButton(orientation, null, null, null, null){
            {
                super(arg0, arg1, arg2, arg3, arg4);
                this.putClientProperty("JButton.noShadowOverwrite", true);
            }

            @Override
            public void paint(Graphics g) {
                int y;
                int x = (this.getWidth() - this.getIcon().getIconWidth()) / 2;
                int n = y = this.direction == 1 ? this.getHeight() - this.getIcon().getIconHeight() + 4 : -4;
                if (center) {
                    y = (this.getHeight() - this.getIcon().getIconHeight()) / 2;
                }
                this.paintTriangle(g, x, y, 0, this.direction, parent.isEnabled());
            }

            @Override
            public Icon getIcon() {
                return this.isEnabled() ? activeIcon : inactiveIcon;
            }

            @Override
            public Dimension getPreferredSize() {
                if (!applyInsetsOnSize) {
                    return new DimensionUIResource(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
                }
                return new DimensionUIResource(this.getIcon().getIconWidth() + insets.left + insets.right, this.getIcon().getIconHeight() + insets.top + insets.bottom);
            }

            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                this.getIcon().paintIcon(this, g, x, y);
            }

            @Override
            public Insets getInsets() {
                return this.getInsets(new Insets(0, 0, 0, 0));
            }

            @Override
            public Insets getInsets(Insets i) {
                i.left = insets.left;
                i.right = insets.right;
                i.top = insets.top;
                i.bottom = insets.bottom;
                return i;
            }

            @Override
            public boolean isOpaque() {
                return false;
            }
        };
    }
}

