/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.color;

import java.awt.Color;
import java.awt.Component;
import javax.swing.UIManager;

public class DarkColorModel {
    private final String prefix;
    private final String[] labels;

    public DarkColorModel() {
        this("rgb", "Red", "Green", "Blue");
    }

    public DarkColorModel(String name, String ... labels) {
        this.prefix = "ColorChooser." + name;
        this.labels = labels;
    }

    public int getCount() {
        return this.labels.length;
    }

    public int getMinimum(int index) {
        return 0;
    }

    public int getMaximum(int index) {
        return 255;
    }

    public int getDefault(int index) {
        return 0;
    }

    public final String getText(Component component, String suffix) {
        return UIManager.getString((Object)(this.prefix + suffix + "Text"), component.getLocale());
    }

    public String toString() {
        return "RGB";
    }

    public int getValueCount() {
        return 3;
    }

    public char[] getLabelDescriptorsBefore() {
        return new char[]{'R', 'G', 'B'};
    }

    public char[] getLabelDescriptorsAfter() {
        return new char[]{'\u0000', '\u0000', '\u0000', '\u0000'};
    }

    public int[] getValuesFromColor(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public Color getColorFromValues(int[] values) {
        return new Color(values[0], values[1], values[2]);
    }
}

