/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class LafManager {
    private static Theme theme;
    private static boolean logEnabled;
    private static boolean decorationsOverwrite;
    private static Properties properties;

    public static void enableLogging(boolean logEnabled) {
        if (logEnabled == LafManager.logEnabled) {
            return;
        }
        if (!logEnabled) {
            LogManager.getLogManager().reset();
        } else {
            try (InputStream inputStream = DarkLaf.class.getClassLoader().getResourceAsStream("com/github/weisj/darklaf/log/logging.properties");){
                if (inputStream != null) {
                    Logger.getGlobal().fine("Loading logging configuration.");
                    LogManager.getLogManager().readConfiguration(inputStream);
                }
                Logger.getGlobal().fine(() -> "Loaded logging config" + LogManager.getLogManager().toString());
            }
            catch (IOException e) {
                Logger.getGlobal().log(Level.SEVERE, "init logging system", e);
            }
        }
        LafManager.logEnabled = logEnabled;
    }

    public static boolean isDecorationsEnabled() {
        return decorationsOverwrite;
    }

    public static void setDecorationsEnabled(boolean enabled) {
        if (decorationsOverwrite != enabled && !(decorationsOverwrite = enabled)) {
            LafManager.updateLaf();
        }
    }

    public static Theme getTheme() {
        if (theme == null) {
            LafManager.setTheme(new IntelliJTheme());
        }
        return theme;
    }

    public static void setTheme(Theme theme) {
        LafManager.theme = theme;
        IconLoader.updateAwareStyle(theme.useDarkIcons() ? AwareIconStyle.DARK : AwareIconStyle.LIGHT);
        IconLoader.updateThemeStatus(theme);
    }

    public static void installTheme(Theme theme) {
        LafManager.setTheme(theme);
        LafManager.install();
    }

    public static void reloadIconTheme() {
        try {
            LafManager.setTheme((Theme)LafManager.getTheme().getClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void install(Theme theme) {
        LafManager.installTheme(theme);
    }

    public static void install() {
        try {
            LafManager.getTheme();
            UIManager.setLookAndFeel(DarkLaf.class.getCanonicalName());
            LafManager.updateLaf();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static void updateLaf() {
        for (Window w : Window.getWindows()) {
            LafManager.updateLafRecursively(w);
        }
    }

    private static void updateLafRecursively(Window window) {
        for (Window childWindow : window.getOwnedWindows()) {
            LafManager.updateLafRecursively(childWindow);
        }
        SwingUtilities.updateComponentTreeUI(window);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static void removeProperty(String key) {
        properties.remove(key);
    }

    public static void clearProperties() {
        properties.clear();
    }

    public static Properties getUserProperties() {
        return properties;
    }

    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    static {
        logEnabled = false;
        decorationsOverwrite = true;
        properties = new Properties();
        LafManager.enableLogging(true);
    }
}

