/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.kmeans.ComputeMeanTuple_F32;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;
import pabeles.concurrency.GrowArray;

public class ComputeMeanTuple_MT_F32
extends ComputeMeanTuple_F32 {
    int minimumForConcurrent = 0;
    final int tupleDof;
    GrowArray<ThreadData> threadData;

    public ComputeMeanTuple_MT_F32(int numElements) {
        this.tupleDof = numElements;
        this.threadData = new GrowArray<ThreadData>(() -> new ThreadData());
    }

    @Override
    public void process(LArrayAccessor<TupleDesc_F32> points, DogArray_I32 assignments, FastAccess<TupleDesc_F32> clusters) {
        if (points.size() < this.minimumForConcurrent) {
            super.process(points, assignments, clusters);
            return;
        }
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        BoofConcurrency.loopBlocks(0, points.size(), this.threadData, (data, idx0, idx1) -> {
            TupleDesc_F32 tuple = data.point;
            DogArray<TupleDesc_F32> sums = data.clusterSums;
            sums.resize(clusters.size);
            for (int i = 0; i < sums.size; ++i) {
                ((TupleDesc_F32)sums.get(i)).fill(0.0f);
            }
            DogArray_I32 counts = data.counts;
            counts.resetResize(sums.size, 0);
            for (int pointIdx = idx0; pointIdx < idx1; ++pointIdx) {
                int clusterIdx;
                points.getCopy(pointIdx, tuple);
                float[] point = tuple.data;
                int n = clusterIdx = assignments.get(pointIdx);
                counts.data[n] = counts.data[n] + 1;
                float[] cluster = ((TupleDesc_F32)sums.get((int)clusterIdx)).data;
                for (int i = 0; i < point.length; ++i) {
                    int n2 = i;
                    cluster[n2] = cluster[n2] + point[i];
                }
            }
        });
        this.counts.resetResize(clusters.size, 0);
        for (int i = 0; i < clusters.size; ++i) {
            clusters.get(i).fill(0.0f);
        }
        for (int threadIdx = 0; threadIdx < this.threadData.size(); ++threadIdx) {
            ThreadData data2 = this.threadData.get(threadIdx);
            for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
                TupleDesc_F32 a = (TupleDesc_F32)data2.clusterSums.get(clusterIdx);
                TupleDesc_F32 b = clusters.get(clusterIdx);
                for (int i = 0; i < b.size(); ++i) {
                    int n = i;
                    b.data[n] = b.data[n] + a.data[i];
                }
                int n = clusterIdx;
                this.counts.data[n] = this.counts.data[n] + data2.counts.data[clusterIdx];
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            float[] cluster = clusters.get((int)clusterIdx).data;
            float divisor = this.counts.get(clusterIdx);
            int i = 0;
            while (i < cluster.length) {
                int n = i++;
                cluster[n] = cluster[n] / divisor;
            }
        }
    }

    @Override
    public ComputeMeanClusters<TupleDesc_F32> newInstanceThread() {
        return new ComputeMeanTuple_MT_F32(this.tupleDof);
    }

    public int getMinimumForConcurrent() {
        return this.minimumForConcurrent;
    }

    public void setMinimumForConcurrent(int minimumForConcurrent) {
        this.minimumForConcurrent = minimumForConcurrent;
    }

    class ThreadData {
        TupleDesc_F32 point;
        DogArray_I32 counts;
        DogArray<TupleDesc_F32> clusterSums;

        ThreadData() {
            this.point = new TupleDesc_F32(ComputeMeanTuple_MT_F32.this.tupleDof);
            this.counts = new DogArray_I32();
            this.clusterSums = new DogArray<TupleDesc_F32>(() -> new TupleDesc_F32(ComputeMeanTuple_MT_F32.this.tupleDof));
        }
    }
}

