/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedInteger;
import org.jetbrains.annotations.Nullable;

public abstract class InterleavedI8<T extends InterleavedI8<T>>
extends InterleavedInteger<T> {
    public byte[] data;

    protected InterleavedI8(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    protected InterleavedI8() {
        this.data = new byte[0];
    }

    @Override
    public String toString_element(int index) {
        return String.format("%02x", this.data[index] & 0xFF);
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.I8;
    }

    public byte[] get(int x, int y, @Nullable byte[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new byte[this.numBands];
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
        return storage;
    }

    public void set(int x, int y, byte ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public void setBand(int x, int y, int band, byte value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    public void unsafe_set(int x, int y, int ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = (byte)value[i];
            ++i;
            ++index;
        }
    }

    @Override
    public void setBand(int x, int y, int band, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = (byte)value;
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        byte[] dst = (byte[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col * this.numBands; idxSrc < end; idxSrc += this.stride) {
            for (int i = 0; i < this.numBands; ++i) {
                dst[idxDst++] = this.data[idxSrc + i];
            }
        }
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Byte.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (byte[])data;
    }
}

