/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.BlockIndexLength;
import boofcv.struct.PointIndex_I32;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class PackedSetsPoint2D_I32 {
    final int blockLength;
    final DogArray<int[]> blocks;
    final DogArray<BlockIndexLength> sets = new DogArray<BlockIndexLength>(BlockIndexLength::new);
    int tailBlockSize;

    public PackedSetsPoint2D_I32(int blockLength) {
        if (blockLength < 2) {
            throw new IllegalArgumentException("Block length must be more than 2");
        }
        this.blockLength = blockLength + blockLength % 2;
        this.blocks = new DogArray<int[]>(int[].class, () -> new int[this.blockLength]);
        this.blocks.grow();
    }

    public PackedSetsPoint2D_I32() {
        this(2000);
    }

    public void reset() {
        this.tailBlockSize = 0;
        this.blocks.reset();
        this.blocks.grow();
        this.sets.reset();
    }

    public void grow() {
        if (this.tailBlockSize >= this.blockLength) {
            this.tailBlockSize = 0;
            this.blocks.grow();
        }
        BlockIndexLength s = this.sets.grow();
        s.block = this.blocks.size - 1;
        s.start = this.tailBlockSize;
        s.length = 0;
    }

    public void removeTail() {
        BlockIndexLength tail = (BlockIndexLength)this.sets.getTail();
        while (this.blocks.size - 1 != tail.block) {
            this.blocks.removeTail();
        }
        this.tailBlockSize = tail.start;
        this.sets.removeTail();
    }

    public void addPointToTail(int x, int y) {
        int[] block;
        if (this.sets.size == 0) {
            this.grow();
        }
        BlockIndexLength tail = (BlockIndexLength)this.sets.getTail();
        int index = tail.start + tail.length * 2;
        int blockIndex = tail.block + index / this.blockLength;
        if (blockIndex == this.blocks.size) {
            this.tailBlockSize = 0;
            block = this.blocks.grow();
        } else {
            block = (int[])this.blocks.get(blockIndex);
        }
        this.tailBlockSize += 2;
        block[index %= this.blockLength] = x;
        block[index + 1] = y;
        ++tail.length;
    }

    public int totalPoints() {
        return (this.blockLength * (this.blocks.size - 1) + this.tailBlockSize) / 2;
    }

    public int size() {
        return this.sets.size;
    }

    public int sizeOfSet(int which) {
        return ((BlockIndexLength)this.sets.get((int)which)).length;
    }

    public void getSet(int which, DogArray<Point2D_I32> list) {
        list.reset();
        BlockIndexLength set = (BlockIndexLength)this.sets.get(which);
        for (int i = 0; i < set.length; ++i) {
            int index = set.start + i * 2;
            int blockIndex = set.block + index / this.blockLength;
            int[] block = (int[])this.blocks.get(blockIndex);
            list.grow().setTo(block[index %= this.blockLength], block[index + 1]);
        }
    }

    public List<Point2D_I32> getSet(int which) {
        DogArray<Point2D_I32> tmp = new DogArray<Point2D_I32>(Point2D_I32::new);
        this.getSet(which, tmp);
        ArrayList<Point2D_I32> output = new ArrayList<Point2D_I32>();
        output.addAll(tmp.toList());
        return output;
    }

    public SetIterator createIterator() {
        return new SetIterator();
    }

    public int sizeOfTail() {
        return this.sets.size == 0 ? 0 : ((BlockIndexLength)this.sets.getTail()).length;
    }

    public void writeOverSet(int which, List<Point2D_I32> points) {
        BlockIndexLength set = (BlockIndexLength)this.sets.get(which);
        if (set.length != points.size()) {
            throw new IllegalArgumentException("points and set don't have the same length");
        }
        for (int i = 0; i < set.length; ++i) {
            int index = set.start + i * 2;
            int blockIndex = set.block + index / this.blockLength;
            Point2D_I32 p = points.get(i);
            int[] block = (int[])this.blocks.get(blockIndex);
            block[index %= this.blockLength] = p.x;
            block[index + 1] = p.y;
        }
    }

    public class SetIterator {
        BlockIndexLength set;
        int pointIndex;
        Point2D_I32 p = new PointIndex_I32();

        public void setup(int whichSet) {
            this.set = (BlockIndexLength)PackedSetsPoint2D_I32.this.sets.get(whichSet);
            this.pointIndex = 0;
        }

        public void setToStart() {
            this.pointIndex = 0;
        }

        public boolean hasNext() {
            return this.pointIndex < this.set.length;
        }

        public Point2D_I32 next() {
            int index = this.set.start + this.pointIndex * 2;
            int blockIndex = this.set.block + index / PackedSetsPoint2D_I32.this.blockLength;
            int[] block = (int[])PackedSetsPoint2D_I32.this.blocks.get(blockIndex);
            this.p.setTo(block[index %= PackedSetsPoint2D_I32.this.blockLength], block[index + 1]);
            ++this.pointIndex;
            return this.p;
        }
    }
}

