/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.Configuration;

public class ConfigGridUniform
implements Configuration {
    public double regionScaleFactor = 2.0;
    public int minCellLength = 5;

    public ConfigGridUniform(double regionScaleFactor, int minCellLength) {
        this.regionScaleFactor = regionScaleFactor;
        this.minCellLength = minCellLength;
    }

    public ConfigGridUniform() {
    }

    public int selectTargetCellSize(int maxSample, int imageWidth, int imageHeight) {
        if (maxSample <= 0) {
            throw new IllegalArgumentException("maxSample must be a positive number");
        }
        int targetLength = (int)Math.ceil(this.regionScaleFactor * Math.sqrt(imageWidth * imageHeight) / Math.sqrt(maxSample));
        targetLength = Math.max(this.minCellLength, targetLength);
        return targetLength;
    }

    @Override
    public void checkValidity() {
        if (this.regionScaleFactor <= 0.0) {
            throw new IllegalArgumentException("Must be greater than 0");
        }
        if (this.minCellLength <= 0) {
            throw new IllegalArgumentException("Must be greater than 0");
        }
        if (this.regionScaleFactor < 1.0) {
            throw new IllegalArgumentException("Scale factor must be greater than zero");
        }
    }

    public ConfigGridUniform setTo(ConfigGridUniform src) {
        this.regionScaleFactor = src.regionScaleFactor;
        this.minCellLength = src.minCellLength;
        return this;
    }

    public ConfigGridUniform copy() {
        return new ConfigGridUniform().setTo(this);
    }
}

