/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.errors.BoofCheckFailure;
import boofcv.misc.BoofLambdas;
import boofcv.misc.PrintStreamInjectIndent;
import boofcv.struct.Configuration;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import georegression.struct.GeoTuple;
import georegression.struct.point.Point2D_F64;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogArray_I8;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrix2x2;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix2x2;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.ConcurrencyOps;
import pabeles.concurrency.GrowArray;

public class BoofMiscOps {
    public static int VERBOSE_PREFIX_LENGTH = 6;
    public static boolean VERBOSE_PRINT_TABLE = true;

    public static long timeNano(BoofLambdas.ProcessCall process) {
        long time0 = System.nanoTime();
        process.process();
        long time1 = System.nanoTime();
        return time1 - time0;
    }

    public static void profile(BoofLambdas.ProcessCall process, String description) {
        long nano = BoofMiscOps.timeNano(process);
        System.out.println("Elapsed: " + (double)nano * 1.0E-6 + " (ms) " + description);
    }

    public static String timeStr() {
        return Instant.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", " ");
    }

    public static String timeStr(long systemTimeMS) {
        return Instant.ofEpochMilli(systemTimeMS).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", " ");
    }

    public static String handlePathTilde(String path) {
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    public static float bound(float value, float min, float max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static double bound(double value, double min, double max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static void offsetPixels(List<Point2D_F64> list, double dx, double dy) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D_F64 p = list.get(i);
            p.x += dx;
            p.y += dy;
        }
    }

    public static String[] toStringArray(List<File> files) {
        String[] output = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            output[i] = files.get(i).getPath();
        }
        return output;
    }

    public static <Point extends GeoTuple<Point>> void copyAll(FastAccess<Point> src, DogArray<Point> dst) {
        dst.reserve(dst.size + src.size);
        for (int i = 0; i < src.size; ++i) {
            ((GeoTuple)dst.grow()).setTo((GeoTuple)src.get(i));
        }
    }

    public static List<File> toFileList(String[] files) {
        ArrayList<File> output = new ArrayList<File>();
        for (String s : files) {
            output.add(new File(s));
        }
        return output;
    }

    public static <T> List<T> asList(T ... objects) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public static List<File> toFileList(List<String> files) {
        ArrayList<File> output = new ArrayList<File>();
        for (String s : files) {
            output.add(new File(s));
        }
        return output;
    }

    public static int bitsToWords(int bits, int wordBits) {
        return bits / wordBits + (bits % wordBits == 0 ? 0 : 1);
    }

    public static int numBands(ImageBase img) {
        if (img instanceof ImageMultiBand) {
            return ((ImageMultiBand)img).getNumBands();
        }
        return 1;
    }

    public static String milliToHuman(long milliseconds) {
        long second = milliseconds / 1000L % 60L;
        long minute = milliseconds / 60000L % 60L;
        long hour = milliseconds / 3600000L % 24L;
        long days = milliseconds / 86400000L;
        return String.format("%03d:%02d:%02d:%02d (days:hrs:min:sec)", days, hour, minute, second);
    }

    public static double diffRatio(double a, double b) {
        return Math.abs(a - b) / Math.max(a, b);
    }

    public static int numDigits(int number) {
        if (number == 0) {
            return 1;
        }
        int adjustment = 0;
        if (number < 0) {
            adjustment = 1;
            number = -number;
        }
        return adjustment + (int)Math.log10(number) + 1;
    }

    public static double pow2(double v) {
        return v * v;
    }

    public static float pow2(float v) {
        return v * v;
    }

    public static void sortFileNames(List<String> images) {
        images.sort(new CompareStringNames());
    }

    public static void sortFilesByName(List<File> images) {
        images.sort(Comparator.comparing(File::getName));
    }

    public static void printMethodInfo(Method target, PrintStream out) {
        Class<?>[] types = target.getParameterTypes();
        out.println("Method: " + target.getName() + " param.length = " + types.length);
        out.print("    { ");
        for (int i = 0; i < types.length; ++i) {
            out.print(types[i].getSimpleName() + " ");
        }
        out.println("}");
    }

    public static boolean parseDimension(String text, ImageDimension dimension) {
        String[] words = text.split(":");
        if (words.length != 2) {
            System.err.println("Parse error splitting dimension");
            return false;
        }
        dimension.width = Integer.parseInt(words[0]);
        dimension.height = Integer.parseInt(words[1]);
        return true;
    }

    public static String toString(Reader r) {
        char[] buff = new char[1024];
        StringBuilder string = new StringBuilder();
        try {
            int size;
            while ((size = r.read(buff)) >= 0) {
                string.append(buff, 0, size);
            }
            return string.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int countNotZero(int[] a, int size) {
        int ret = 0;
        for (int i = 0; i < size; ++i) {
            if (a[i] == 0) continue;
            ++ret;
        }
        return ret;
    }

    public static double[] convertTo_F64(int[] a) {
        double[] ret = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static float[] convertTo_F32(double[] a, float[] ret) {
        if (ret == null) {
            ret = new float[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (float)a[i];
        }
        return ret;
    }

    public static int[] convertTo_I32(double[] a, int[] ret) {
        if (ret == null) {
            ret = new int[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (int)a[i];
        }
        return ret;
    }

    public static void boundRectangleInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            r.x0 = 0;
        }
        if (r.x1 > b.width) {
            r.x1 = b.width;
        }
        if (r.y0 < 0) {
            r.y0 = 0;
        }
        if (r.y1 > b.height) {
            r.y1 = b.height;
        }
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static boolean isInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            return false;
        }
        if (r.x1 > b.width) {
            return false;
        }
        if (r.y0 < 0) {
            return false;
        }
        return r.y1 <= b.height;
    }

    public static boolean isInside(ImageBase b, int x, int y, int radius) {
        if (x - radius < 0) {
            return false;
        }
        if (x + radius >= b.width) {
            return false;
        }
        if (y - radius < 0) {
            return false;
        }
        return y + radius < b.height;
    }

    public static boolean isInside(ImageBase b, float x, float y, float radius) {
        if (x - radius < 0.0f) {
            return false;
        }
        if (x + radius > (float)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0f) {
            return false;
        }
        return !(y + radius > (float)(b.height - 1));
    }

    public static boolean isInside(ImageBase b, double x, double y, double radius) {
        if (x - radius < 0.0) {
            return false;
        }
        if (x + radius > (double)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0) {
            return false;
        }
        return !(y + radius > (double)(b.height - 1));
    }

    public static boolean isInside(ImageBase b, int x, int y, int radiusWidth, int radiusHeight) {
        if (x - radiusWidth < 0) {
            return false;
        }
        if (x + radiusWidth >= b.width) {
            return false;
        }
        if (y - radiusHeight < 0) {
            return false;
        }
        return y + radiusHeight < b.height;
    }

    public static boolean isInside(ImageBase b, int c_x, int c_y, int radius, double theta) {
        float s;
        int r = radius;
        float c = (float)Math.cos(theta);
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, -r, c, s = (float)Math.sin(theta))) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, r, c, s)) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, r, r, c, s)) {
            return false;
        }
        return BoofMiscOps.checkInBounds(b, c_x, c_y, r, -r, c, s);
    }

    private static boolean checkInBounds(ImageBase b, int c_x, int c_y, int dx, int dy, float c, float s) {
        float x = (float)c_x + c * (float)dx - s * (float)dy;
        float y = (float)c_y + s * (float)dx + c * (float)dy;
        return b.isInBounds((int)x, (int)y);
    }

    public static boolean isInside(ImageBase b, float x, float y) {
        return x >= 0.0f && x < (float)b.width && y >= 0.0f && y < (float)b.height;
    }

    public static boolean isInside(ImageBase b, double x, double y) {
        return x >= 0.0 && x < (double)b.width && y >= 0.0 && y < (double)b.height;
    }

    public static boolean isInside(int width, int height, float x, float y) {
        return x >= 0.0f && x < (float)width && y >= 0.0f && y < (float)height;
    }

    public static boolean isInside(int width, int height, double x, double y) {
        return x >= 0.0 && x < (double)width && y >= 0.0 && y < (double)height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(long milli) {
        Thread t = Thread.currentThread();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < milli) {
            Thread thread = t;
            synchronized (thread) {
                try {
                    long target = milli - (System.currentTimeMillis() - start);
                    if (target > 0L) {
                        t.wait(target);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void print(ImageGray a) {
        if (a.getDataType().isInteger()) {
            BoofMiscOps.print((GrayI)a);
        } else if (a instanceof GrayF32) {
            BoofMiscOps.print((GrayF32)a);
        } else {
            BoofMiscOps.print((GrayF64)a);
        }
    }

    public static void print(GrayF64 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(GrayF32 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", Float.valueOf(a.get(x, y)));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(InterleavedF32 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.print("|");
                for (int band = 0; band < a.numBands; ++band) {
                    System.out.printf(" %6.2f", Float.valueOf(a.getBand(x, y, band)));
                }
                System.out.print(" |");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(GrayI a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%4d ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static int[] convertArray(double[] input, @Nullable int[] output) {
        if (output == null) {
            output = new int[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (int)input[i];
        }
        return output;
    }

    public static long[] convertArray(double[] input, @Nullable long[] output) {
        if (output == null) {
            output = new long[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (long)input[i];
        }
        return output;
    }

    public static float[] convertArray(double[] input, @Nullable float[] output) {
        if (output == null) {
            output = new float[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (float)input[i];
        }
        return output;
    }

    public static double[] convertArray(float[] input, @Nullable double[] output) {
        if (output == null) {
            output = new double[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static int[] convertArray(float[] input, @Nullable int[] output) {
        if (output == null) {
            output = new int[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (int)input[i];
        }
        return output;
    }

    public static float[] convertArray(int[] input, @Nullable float[] output) {
        if (output == null) {
            output = new float[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static void sleep(long milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void checkTrue(boolean result) {
        BoofMiscOps.checkTrue(result, "Assert failed.");
    }

    public static void checkTrue(boolean result, String message) {
        if (!result) {
            throw new BoofCheckFailure(message);
        }
    }

    public static void checkEq(int valA, int valB) {
        BoofMiscOps.checkEq(valA, valB, "not equals");
    }

    public static void checkEq(int valA, int valB, String message) {
        if (valA != valB) {
            throw new BoofCheckFailure(valA + " != " + valB + " " + message);
        }
    }

    public static void checkSame(Object a, Object b) {
        BoofMiscOps.checkSame(a, b, "");
    }

    public static void checkSame(Object a, Object b, String message) {
        if (a == b) {
            return;
        }
        throw new BoofCheckFailure("Objects not the same instance. " + message);
    }

    public static void checkFraction(double fraction, String message) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new BoofCheckFailure("Fraction out of range. " + fraction + " " + message);
        }
    }

    public static <T> void forIdx(List<T> list, BoofLambdas.ProcessIndex<T> func) {
        for (int i = 0; i < list.size(); ++i) {
            func.process(i, list.get(i));
        }
    }

    public static <T> int indexOf(List<T> list, BoofLambdas.Filter<T> op) {
        for (int i = 0; i < list.size(); ++i) {
            if (!op.keep(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <In, Out> List<Out> collectList(List<In> list, BoofLambdas.Extract<In, Out> func) {
        ArrayList<Out> out = new ArrayList<Out>();
        for (int i = 0; i < list.size(); ++i) {
            In input = list.get(i);
            out.add(func.process(input));
        }
        return out;
    }

    public static double uniform(double min, double max, Random rand) {
        return rand.nextDouble() * (max - min) + min;
    }

    public static float uniform(float min, float max, Random rand) {
        return rand.nextFloat() * (max - min) + min;
    }

    public static <T> T tail(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T removeTail(List<T> list) {
        return list.remove(list.size() - 1);
    }

    public static <T> String toString(T o, BoofLambdas.ToString<T> op) {
        if (o == null) {
            return "Null";
        }
        return op.process(o);
    }

    public static int columnMaxAbsRow(DMatrixRMaj A2, int column) {
        int selected = -1;
        double largestValue = -1.0;
        for (int row = 0; row < A2.numRows; ++row) {
            double v = Math.abs(A2.unsafe_get(row, column));
            if (!(v > largestValue)) continue;
            largestValue = v;
            selected = row;
        }
        return selected;
    }

    public static <T> List<T> createListFilled(int total, BoofLambdas.Factory<T> factory) {
        ArrayList<T> out = new ArrayList<T>();
        for (int i = 0; i < total; ++i) {
            out.add(factory.newInstance());
        }
        return out;
    }

    public static <V> V getOrThrow(Map map, Object key) throws IOException {
        Object value = map.get(key);
        if (value == null) {
            throw new IOException("Key not found in map. key=" + key);
        }
        return value;
    }

    public static <T> boolean containsDuplicates(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < list.size(); ++i) {
            T o = list.get(i);
            if (set.add(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean[] checkDeclare(@Nullable DogArray_B queue, int length, boolean zero) {
        if (queue == null) {
            queue = new DogArray_B(length);
        }
        queue.resize(length);
        if (zero) {
            queue.fill(false);
        }
        return queue.data;
    }

    public static byte[] checkDeclare(@Nullable DogArray_I8 queue, int length, boolean zero) {
        if (queue == null) {
            queue = new DogArray_I8(length);
        }
        queue.resize(length);
        if (zero) {
            queue.fill((byte)0);
        }
        return queue.data;
    }

    public static int[] checkDeclare(@Nullable DogArray_I32 queue, int length, boolean zero) {
        if (queue == null) {
            queue = new DogArray_I32(length);
        }
        queue.resize(length);
        if (zero) {
            queue.fill(0);
        }
        return queue.data;
    }

    public static float[] checkDeclare(@Nullable DogArray_F32 queue, int length, boolean zero) {
        if (queue == null) {
            queue = new DogArray_F32(length);
        }
        queue.resize(length);
        if (zero) {
            queue.fill(0.0f);
        }
        return queue.data;
    }

    public static double[] checkDeclare(@Nullable DogArray_F64 queue, int length, boolean zero) {
        if (queue == null) {
            queue = new DogArray_F64(length);
        }
        queue.resize(length);
        if (zero) {
            queue.fill(0.0);
        }
        return queue.data;
    }

    public static <T> GrowArray<T> checkDeclare(@Nullable GrowArray<T> growable, ConcurrencyOps.NewInstance<T> factory) {
        growable = growable == null ? new GrowArray<T>(factory) : growable;
        growable.reset();
        return growable;
    }

    public static double similarity(String s1, String s2) {
        int longerLength;
        String longer = s1;
        String shorter = s2;
        if (s1.length() < s2.length()) {
            longer = s2;
            shorter = s1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        return (double)(longerLength - BoofMiscOps.editDistance(longer, shorter)) / (double)longerLength;
    }

    public static int editDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    public static <C extends Configuration> C copyConfig(C src) {
        try {
            Class<?> type = src.getClass();
            Configuration dst = (Configuration)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            type.getMethod("setTo", type).invoke((Object)dst, src);
            return (C)dst;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void verboseChildren(@Nullable PrintStream out, @Nullable Set<String> configuration, VerbosePrint ... children) {
        int numIndents = 0;
        PrintStream originalOut = out;
        if (out instanceof PrintStreamInjectIndent) {
            numIndents = ((PrintStreamInjectIndent)out).getIndentCount();
            originalOut = ((PrintStreamInjectIndent)out).getOriginalStream();
        }
        if (configuration == null || !configuration.contains("recursive")) {
            return;
        }
        if (out == null) {
            for (int i = 0; i < children.length; ++i) {
                children[i].setVerbose(null, configuration);
            }
            return;
        }
        ++numIndents;
        for (int i = 0; i < children.length; ++i) {
            PrintStream tabbed = BoofMiscOps.addPrefix(children[i], numIndents, originalOut);
            children[i].setVerbose(tabbed, configuration);
        }
    }

    public static <T> String toStringLine(List<T> list) {
        Object out = "{ ";
        for (int i = 0; i < list.size(); ++i) {
            out = (String)out + "'" + list.get(i) + "' ";
        }
        return (String)out + "}";
    }

    @Nullable
    public static PrintStream addPrefix(VerbosePrint owner, @Nullable PrintStream out) {
        return BoofMiscOps.addPrefix(owner, 1, out);
    }

    @Nullable
    public static PrintStream addPrefix(VerbosePrint owner, int numIndents, @Nullable PrintStream out) {
        if (out == null || out instanceof PrintStreamInjectIndent) {
            return out;
        }
        String simpleName = owner.getClass().getSimpleName();
        String pre = BoofMiscOps.nameToShort(simpleName, VERBOSE_PREFIX_LENGTH);
        if (VERBOSE_PRINT_TABLE) {
            out.println("Verbose: " + pre + " " + simpleName);
        }
        return new PrintStreamInjectIndent(pre, numIndents, out);
    }

    public static String nameToShort(String name, int length) {
        int i;
        Object text = "";
        for (i = 0; i < name.length() && ((String)text).length() < length; ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c) && !Character.isDigit(c)) continue;
            text = (String)text + c;
        }
        if (((String)text).length() < length) {
            for (i = ((String)text).length(); i < length; ++i) {
                text = (String)text + "-";
            }
        }
        return text;
    }

    public static <T> Set<T> hashSet(T ... values) {
        HashSet<T> ret = new HashSet<T>();
        for (int i = 0; i < values.length; ++i) {
            ret.add(values[i]);
        }
        return ret;
    }

    public static void convertMatrix(FMatrix2x2 src, DMatrixRMaj dst) {
        dst.reshape(2, 2);
        dst.data[0] = src.a11;
        dst.data[1] = src.a12;
        dst.data[2] = src.a21;
        dst.data[3] = src.a22;
    }

    public static void convertMatrix(DMatrix2x2 src, DMatrixRMaj dst) {
        dst.reshape(2, 2);
        dst.data[0] = src.a11;
        dst.data[1] = src.a12;
        dst.data[2] = src.a21;
        dst.data[3] = src.a22;
    }

    public static double[] copySmart(double[] src, @Nullable double[] dst) {
        if (dst == null || dst.length != src.length) {
            dst = new double[src.length];
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static int generateBitMask(int numBits) {
        int mask = 0;
        for (int i = 0; i < numBits; ++i) {
            mask |= 1 << i;
        }
        return mask;
    }

    private static class CompareStringNames
    implements Comparator<String> {
        private CompareStringNames() {
        }

        @Override
        public int compare(String a, String b) {
            if (a.length() < b.length()) {
                return -1;
            }
            if (a.length() > b.length()) {
                return 1;
            }
            return a.compareTo(b);
        }
    }
}

