/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.UtilIO;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class PlyCodec {
    public static void saveAscii(PointCloudReader cloud, boolean saveRgb, Writer outputWriter) throws IOException {
        outputWriter.write("ply\n");
        outputWriter.write("format ascii 1.0\n");
        outputWriter.write("comment Created using BoofCV!\n");
        outputWriter.write("element vertex " + cloud.size() + "\nproperty float x\nproperty float y\nproperty float z\n");
        if (saveRgb) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n");
        }
        outputWriter.write("end_header\n");
        Point3D_F64 p = new Point3D_F64();
        for (int i = 0; i < cloud.size(); ++i) {
            cloud.get(i, p);
            if (saveRgb) {
                int rgb = cloud.getRGB(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                outputWriter.write(String.format("%f %f %f %d %d %d\n", p.x, p.y, p.z, r, g, b));
                continue;
            }
            outputWriter.write(String.format("%f %f %f\n", p.x, p.y, p.z));
        }
        outputWriter.flush();
    }

    public static void saveBinary(PointCloudReader cloud, ByteOrder order, boolean saveRgb, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        String format = "UTF-8";
        String dataType = saveAsFloat ? "float" : "double";
        int dataLength = saveAsFloat ? 4 : 8;
        outputWriter.write("ply\n".getBytes(format));
        outputWriter.write("format binary_big_endian 1.0\n".getBytes(format));
        outputWriter.write("comment Created using BoofCV!\n".getBytes(format));
        outputWriter.write(("element vertex " + cloud.size() + "\n").getBytes(format));
        outputWriter.write(("property " + dataType + " x\nproperty " + dataType + " y\nproperty " + dataType + " z\n").getBytes(format));
        if (saveRgb) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n".getBytes(format));
        }
        outputWriter.write("end_header\n".getBytes(format));
        int end = dataLength * 3;
        ByteBuffer bytes = ByteBuffer.allocate(dataLength * 3 + (saveRgb ? 3 : 0));
        bytes.order(order);
        Point3D_F64 p = new Point3D_F64();
        for (int i = 0; i < cloud.size(); ++i) {
            cloud.get(i, p);
            if (saveAsFloat) {
                bytes.putFloat(0, (float)p.x);
                bytes.putFloat(4, (float)p.y);
                bytes.putFloat(8, (float)p.z);
            } else {
                bytes.putDouble(0, p.x);
                bytes.putDouble(8, p.y);
                bytes.putDouble(16, p.z);
            }
            if (saveRgb) {
                int rgb = cloud.getRGB(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                bytes.put(end, (byte)r);
                bytes.put(end + 1, (byte)g);
                bytes.put(end + 2, (byte)b);
            }
            outputWriter.write(bytes.array());
        }
        outputWriter.flush();
    }

    private static String readNextPly(InputStream reader, boolean failIfNull, StringBuilder buffer) throws IOException {
        String line = UtilIO.readLine(reader, buffer);
        while (line.length() != 0) {
            if (line.startsWith("comment")) {
                line = UtilIO.readLine(reader, buffer);
                continue;
            }
            return line;
        }
        if (failIfNull) {
            throw new IOException("Unexpected end of file");
        }
        return line;
    }

    public static void read(InputStream input, PointCloudWriter output) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String line = UtilIO.readLine(input, buffer);
        if (line.length() == 0) {
            throw new IOException("Missing first line");
        }
        if (line.compareToIgnoreCase("ply") != 0) {
            throw new IOException("Expected PLY at start of file");
        }
        ArrayList<DataWord> dataWords = new ArrayList<DataWord>();
        int vertexCount = -1;
        Enum format = null;
        boolean rgb = false;
        line = PlyCodec.readNextPly(input, true, buffer);
        while (line.length() != 0 && !line.equals("end_header")) {
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                throw new IOException("Expected more than one word");
            }
            if (line.startsWith("format")) {
                Format format2;
                switch (words[1]) {
                    case "ascii": {
                        format2 = Format.ASCII;
                        break;
                    }
                    case "binary_little_endian": {
                        format2 = Format.BINARY_LITTLE;
                        break;
                    }
                    case "binary_big_endian": {
                        format2 = Format.BINARY_BIG;
                        break;
                    }
                    default: {
                        throw new IOException("Unknown format " + words[1]);
                    }
                }
                format = format2;
            } else if (line.startsWith("element")) {
                if (words[1].equals("vertex")) {
                    vertexCount = Integer.parseInt(words[2]);
                }
            } else if (words[0].equals("property")) {
                VarType v;
                DataType dataType;
                switch (words[1].toLowerCase()) {
                    case "float": {
                        dataType = DataType.FLOAT;
                        break;
                    }
                    case "double": {
                        dataType = DataType.DOUBLE;
                        break;
                    }
                    case "char": {
                        dataType = DataType.CHAR;
                        break;
                    }
                    case "short": {
                        dataType = DataType.SHORT;
                        break;
                    }
                    case "int": {
                        dataType = DataType.INT;
                        break;
                    }
                    case "uchar": {
                        dataType = DataType.UCHAR;
                        break;
                    }
                    case "ushort": {
                        dataType = DataType.USHORT;
                        break;
                    }
                    case "uint": {
                        dataType = DataType.UINT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Add support for " + words[1]);
                    }
                }
                DataType d = dataType;
                switch (words[2].toLowerCase()) {
                    case "x": {
                        v = VarType.X;
                        break;
                    }
                    case "y": {
                        v = VarType.Y;
                        break;
                    }
                    case "z": {
                        v = VarType.Z;
                        break;
                    }
                    case "red": {
                        v = VarType.R;
                        rgb = true;
                        break;
                    }
                    case "green": {
                        v = VarType.G;
                        rgb = true;
                        break;
                    }
                    case "blue": {
                        v = VarType.B;
                        rgb = true;
                        break;
                    }
                    default: {
                        v = VarType.UNKNOWN;
                    }
                }
                dataWords.add(new DataWord(v, d));
            } else {
                throw new IOException("Unknown header element");
            }
            line = PlyCodec.readNextPly(input, true, buffer);
        }
        if (vertexCount == -1) {
            throw new IOException("File is missing vertex count");
        }
        if (format == null) {
            throw new IOException("Format is never specified");
        }
        output.initialize(vertexCount, rgb);
        switch (1.$SwitchMap$boofcv$io$points$impl$PlyCodec$Format[format.ordinal()]) {
            case 1: {
                PlyCodec.readAscii(output, input, dataWords, buffer, vertexCount, rgb);
                break;
            }
            case 2: {
                PlyCodec.readBinary(output, input, dataWords, ByteOrder.LITTLE_ENDIAN, vertexCount, rgb);
                break;
            }
            case 3: {
                PlyCodec.readBinary(output, input, dataWords, ByteOrder.BIG_ENDIAN, vertexCount, rgb);
                break;
            }
            default: {
                throw new RuntimeException("BUG!");
            }
        }
    }

    private static void readAscii(PointCloudWriter output, InputStream reader, List<DataWord> dataWords, StringBuilder buffer, int vertexCount, boolean rgb) throws IOException {
        int I32 = -1;
        double F642 = -1.0;
        int r = -1;
        int g = -1;
        int b = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        for (int i = 0; i < vertexCount; ++i) {
            String line = PlyCodec.readNextPly(reader, true, buffer);
            String[] words = line.split("\\s+");
            if (words.length != dataWords.size()) {
                throw new IOException("unexpected number of words. " + line);
            }
            block13: for (int j = 0; j < dataWords.size(); ++j) {
                DataWord d = dataWords.get(j);
                String word = words[j];
                switch (d.data) {
                    case FLOAT: 
                    case DOUBLE: {
                        F642 = Double.parseDouble(word);
                        break;
                    }
                    case UINT: 
                    case INT: 
                    case USHORT: 
                    case SHORT: 
                    case UCHAR: 
                    case CHAR: {
                        I32 = Integer.parseInt(word);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                switch (d.var) {
                    case X: {
                        x = F642;
                        continue block13;
                    }
                    case Y: {
                        y = F642;
                        continue block13;
                    }
                    case Z: {
                        z = F642;
                        continue block13;
                    }
                    case R: {
                        r = I32;
                        continue block13;
                    }
                    case G: {
                        g = I32;
                        continue block13;
                    }
                    case B: {
                        b = I32;
                        continue block13;
                    }
                }
            }
            if (rgb) {
                output.add(x, y, z, r << 16 | g << 8 | b);
                continue;
            }
            output.add(x, y, z, 0);
        }
    }

    private static void readBinary(PointCloudWriter output, InputStream reader, List<DataWord> dataWords, ByteOrder order, int vertexCount, boolean rgb) throws IOException {
        int totalBytes = 0;
        for (int i = 0; i < dataWords.size(); ++i) {
            totalBytes += dataWords.get((int)i).data.size;
        }
        byte[] line = new byte[totalBytes];
        ByteBuffer bb = ByteBuffer.wrap(line);
        bb.order(order);
        int I32 = -1;
        double F642 = -1.0;
        int r = -1;
        int g = -1;
        int b = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        for (int i = 0; i < vertexCount; ++i) {
            int found = reader.read(line);
            if (line.length != found) {
                throw new IOException("Read unexpected number of bytes. " + found + " vs " + line.length);
            }
            int location = 0;
            block20: for (int j = 0; j < dataWords.size(); ++j) {
                DataWord d = dataWords.get(j);
                switch (d.data) {
                    case FLOAT: {
                        F642 = bb.getFloat(location);
                        break;
                    }
                    case DOUBLE: {
                        F642 = bb.getDouble(location);
                        break;
                    }
                    case CHAR: {
                        I32 = bb.get(location);
                        break;
                    }
                    case UCHAR: {
                        I32 = bb.get(location) & 0xFF;
                        break;
                    }
                    case SHORT: {
                        I32 = bb.getShort(location);
                        break;
                    }
                    case USHORT: {
                        I32 = bb.getShort(location) & 0xFFFF;
                        break;
                    }
                    case INT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    case UINT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                location += d.data.size;
                switch (d.var) {
                    case X: {
                        x = F642;
                        continue block20;
                    }
                    case Y: {
                        y = F642;
                        continue block20;
                    }
                    case Z: {
                        z = F642;
                        continue block20;
                    }
                    case R: {
                        r = I32;
                        continue block20;
                    }
                    case G: {
                        g = I32;
                        continue block20;
                    }
                    case B: {
                        b = I32;
                        continue block20;
                    }
                }
            }
            if (rgb) {
                output.add(x, y, z, r << 16 | g << 8 | b);
                continue;
            }
            output.add(x, y, z, 0);
        }
    }

    private static enum Format {
        ASCII,
        BINARY_LITTLE,
        BINARY_BIG;

    }

    private static enum DataType {
        FLOAT(4),
        DOUBLE(8),
        CHAR(1),
        SHORT(2),
        INT(4),
        UCHAR(1),
        USHORT(2),
        UINT(4);

        final int size;

        private DataType(int size) {
            this.size = size;
        }
    }

    private static enum VarType {
        X,
        Y,
        Z,
        R,
        G,
        B,
        UNKNOWN;

    }

    private static class DataWord {
        VarType var;
        DataType data;

        public DataWord(VarType var, DataType data) {
            this.var = var;
            this.data = data;
        }
    }
}

