/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.UtilIO;
import boofcv.io.image.PolygonRegion;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class LabeledImagePolygonCodec {
    public static void encode(List<PolygonRegion> regions, int width, int height, OutputStream writer, String ... comments) throws IOException {
        writer.write(String.format("LabeledPolygon,w=%d,h=%d,labels=%d,format=txt,version=1\n", width, height, regions.size()).getBytes(StandardCharsets.UTF_8));
        for (String comment : comments) {
            writer.write(("# " + comment + "\n").getBytes(StandardCharsets.UTF_8));
        }
        for (PolygonRegion region : regions) {
            String line = region.regionID + "," + region.polygon.size();
            for (int i = 0; i < region.polygon.size(); ++i) {
                Point2D_F64 p = region.polygon.get(i);
                line = line + String.format(",%.17g,%.17g", p.x, p.y);
            }
            writer.write((line + "\n").getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void decode(InputStream reader, ImageDimension shape, DogArray<PolygonRegion> regions) throws IOException {
        regions.reset();
        StringBuilder buffer = new StringBuilder(1024);
        String line = UtilIO.readLine(reader, buffer);
        if (!line.startsWith("LabeledPolygon")) {
            throw new IOException("Invalid. Does not start with LabeledPolygon");
        }
        String[] words = line.split(",");
        int width = 0;
        int height = 0;
        int version = -1;
        boolean txt = false;
        block12: for (int i = 1; i < words.length; ++i) {
            String[] values = words[i].split("=");
            if (values.length != 2) {
                throw new IOException("Unexpected: " + words[i]);
            }
            switch (values[0]) {
                case "w": {
                    width = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "h": {
                    height = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "version": {
                    version = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "format": {
                    txt = values[1].equalsIgnoreCase("txt");
                }
            }
        }
        if (!txt) {
            throw new IOException("Can only read text format");
        }
        if (version <= 0) {
            throw new IOException("Unknown version.");
        }
        shape.setTo(width, height);
        while (reader.available() > 0) {
            line = UtilIO.readLine(reader, buffer);
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            words = line.split(",");
            if (words.length < 2) {
                throw new IOException("Unexpected: " + line);
            }
            int regionID = Integer.parseInt(words[0]);
            int size = Integer.parseInt(words[1]);
            if (size * 2 + 2 != words.length) {
                throw new IOException("Unexpected number of words. " + line);
            }
            PolygonRegion region = regions.grow();
            region.regionID = regionID;
            region.polygon.vertexes.resize(size);
            for (int i = 2; i < words.length; i += 2) {
                double x = Double.parseDouble(words[i]);
                double y = Double.parseDouble(words[i + 1]);
                ((Point2D_F64)region.polygon.vertexes.get((i - 2) / 2)).setTo(x, y);
            }
        }
    }
}

